// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef PROJECTATTRIBUTES_H
#define PROJECTATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: ProjectAttributes
//
// Purpose:
//    Project data from three to two dimensions
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class ProjectAttributes : public AttributeSubject
{
public:
    enum ProjectionType
    {
        ZYCartesian,
        XZCartesian,
        XYCartesian,
        XRCylindrical,
        YRCylindrical,
        ZRCylindrical
    };
    enum VectorTransformMethod
    {
        None,
        AsPoint,
        AsDisplacement,
        AsDirection
    };

    // These constructors are for objects of this class
    ProjectAttributes();
    ProjectAttributes(const ProjectAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    ProjectAttributes(private_tmfs_t tmfs);
    ProjectAttributes(const ProjectAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~ProjectAttributes();

    virtual ProjectAttributes& operator = (const ProjectAttributes &obj);
    virtual bool operator == (const ProjectAttributes &obj) const;
    virtual bool operator != (const ProjectAttributes &obj) const;
private:
    void Init();
    void Copy(const ProjectAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();

    // Property setting methods
    void SetProjectionType(ProjectionType projectionType_);
    void SetVectorTransformMethod(VectorTransformMethod vectorTransformMethod_);

    // Property getting methods
    ProjectionType GetProjectionType() const;
    VectorTransformMethod GetVectorTransformMethod() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string ProjectionType_ToString(ProjectionType);
    static bool ProjectionType_FromString(const std::string &, ProjectionType &);
protected:
    static std::string ProjectionType_ToString(int);
public:
    static std::string VectorTransformMethod_ToString(VectorTransformMethod);
    static bool VectorTransformMethod_FromString(const std::string &, VectorTransformMethod &);
protected:
    static std::string VectorTransformMethod_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_projectionType = 0,
        ID_vectorTransformMethod,
        ID__LAST
    };

private:
    int projectionType;
    int vectorTransformMethod;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define PROJECTATTRIBUTES_TMFS "ii"

#endif
