// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  PoincareScriptingPluginInfo.C
// ************************************************************************* //
#include <PyPoincareAttributes.h>
#include <PoincarePluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(Poincare,Scripting)

// ****************************************************************************
// Method: PoincareScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
PoincareScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyPoincareAttributes_StartUp((PoincareAttributes *)subj, data);
}

// ****************************************************************************
// Method: PoincareScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
PoincareScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyPoincareAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: PoincareScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is Poincare plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
PoincareScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyPoincareAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: PoincareScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
PoincareScriptingPluginInfo::GetLogString()
{
    std::string s(PyPoincareAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: PoincareScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
PoincareScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyPoincareAttributes_SetDefaults((const PoincareAttributes *)atts);
}
