// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  PersistentParticlesScriptingPluginInfo.C
// ************************************************************************* //
#include <PyPersistentParticlesAttributes.h>
#include <PersistentParticlesPluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(PersistentParticles,Scripting)

// ****************************************************************************
// Method: PersistentParticlesScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
PersistentParticlesScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyPersistentParticlesAttributes_StartUp((PersistentParticlesAttributes *)subj, data);
}

// ****************************************************************************
// Method: PersistentParticlesScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
PersistentParticlesScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyPersistentParticlesAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: PersistentParticlesScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is PersistentParticles plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
PersistentParticlesScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyPersistentParticlesAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: PersistentParticlesScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
PersistentParticlesScriptingPluginInfo::GetLogString()
{
    std::string s(PyPersistentParticlesAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: PersistentParticlesScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
PersistentParticlesScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyPersistentParticlesAttributes_SetDefaults((const PersistentParticlesAttributes *)atts);
}
