// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyPDFAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>

// ****************************************************************************
// Module: PyPDFAttributes
//
// Purpose:
//   Attributes for the PDF operator
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a PDFAttributes.
//
struct PDFAttributesObject
{
    PyObject_HEAD
    PDFAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewPDFAttributes(int);

std::string
PyPDFAttributes_ToString(const PDFAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    snprintf(tmpStr, 1000, "%svar1 = \"%s\"\n", prefix, atts->GetVar1().c_str());
    str += tmpStr;
    if(atts->GetVar1MinFlag())
        snprintf(tmpStr, 1000, "%svar1MinFlag = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%svar1MinFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetVar1MaxFlag())
        snprintf(tmpStr, 1000, "%svar1MaxFlag = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%svar1MaxFlag = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%svar1Min = %g\n", prefix, atts->GetVar1Min());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%svar1Max = %g\n", prefix, atts->GetVar1Max());
    str += tmpStr;
    const char *var1Scaling_names = "Linear, Log, Skew";
    switch (atts->GetVar1Scaling())
    {
      case PDFAttributes::Linear:
          snprintf(tmpStr, 1000, "%svar1Scaling = %sLinear  # %s\n", prefix, prefix, var1Scaling_names);
          str += tmpStr;
          break;
      case PDFAttributes::Log:
          snprintf(tmpStr, 1000, "%svar1Scaling = %sLog  # %s\n", prefix, prefix, var1Scaling_names);
          str += tmpStr;
          break;
      case PDFAttributes::Skew:
          snprintf(tmpStr, 1000, "%svar1Scaling = %sSkew  # %s\n", prefix, prefix, var1Scaling_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    snprintf(tmpStr, 1000, "%svar1SkewFactor = %g\n", prefix, atts->GetVar1SkewFactor());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%svar1NumSamples = %d\n", prefix, atts->GetVar1NumSamples());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%svar2 = \"%s\"\n", prefix, atts->GetVar2().c_str());
    str += tmpStr;
    if(atts->GetVar2MinFlag())
        snprintf(tmpStr, 1000, "%svar2MinFlag = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%svar2MinFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetVar2MaxFlag())
        snprintf(tmpStr, 1000, "%svar2MaxFlag = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%svar2MaxFlag = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%svar2Min = %g\n", prefix, atts->GetVar2Min());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%svar2Max = %g\n", prefix, atts->GetVar2Max());
    str += tmpStr;
    const char *var2Scaling_names = "Linear, Log, Skew";
    switch (atts->GetVar2Scaling())
    {
      case PDFAttributes::Linear:
          snprintf(tmpStr, 1000, "%svar2Scaling = %sLinear  # %s\n", prefix, prefix, var2Scaling_names);
          str += tmpStr;
          break;
      case PDFAttributes::Log:
          snprintf(tmpStr, 1000, "%svar2Scaling = %sLog  # %s\n", prefix, prefix, var2Scaling_names);
          str += tmpStr;
          break;
      case PDFAttributes::Skew:
          snprintf(tmpStr, 1000, "%svar2Scaling = %sSkew  # %s\n", prefix, prefix, var2Scaling_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    snprintf(tmpStr, 1000, "%svar2SkewFactor = %g\n", prefix, atts->GetVar2SkewFactor());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%svar2NumSamples = %d\n", prefix, atts->GetVar2NumSamples());
    str += tmpStr;
    const char *numAxes_names = "Two, Three";
    switch (atts->GetNumAxes())
    {
      case PDFAttributes::Two:
          snprintf(tmpStr, 1000, "%snumAxes = %sTwo  # %s\n", prefix, prefix, numAxes_names);
          str += tmpStr;
          break;
      case PDFAttributes::Three:
          snprintf(tmpStr, 1000, "%snumAxes = %sThree  # %s\n", prefix, prefix, numAxes_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    snprintf(tmpStr, 1000, "%svar3 = \"%s\"\n", prefix, atts->GetVar3().c_str());
    str += tmpStr;
    if(atts->GetVar3MinFlag())
        snprintf(tmpStr, 1000, "%svar3MinFlag = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%svar3MinFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetVar3MaxFlag())
        snprintf(tmpStr, 1000, "%svar3MaxFlag = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%svar3MaxFlag = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%svar3Min = %g\n", prefix, atts->GetVar3Min());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%svar3Max = %g\n", prefix, atts->GetVar3Max());
    str += tmpStr;
    const char *var3Scaling_names = "Linear, Log, Skew";
    switch (atts->GetVar3Scaling())
    {
      case PDFAttributes::Linear:
          snprintf(tmpStr, 1000, "%svar3Scaling = %sLinear  # %s\n", prefix, prefix, var3Scaling_names);
          str += tmpStr;
          break;
      case PDFAttributes::Log:
          snprintf(tmpStr, 1000, "%svar3Scaling = %sLog  # %s\n", prefix, prefix, var3Scaling_names);
          str += tmpStr;
          break;
      case PDFAttributes::Skew:
          snprintf(tmpStr, 1000, "%svar3Scaling = %sSkew  # %s\n", prefix, prefix, var3Scaling_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    snprintf(tmpStr, 1000, "%svar3SkewFactor = %g\n", prefix, atts->GetVar3SkewFactor());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%svar3NumSamples = %d\n", prefix, atts->GetVar3NumSamples());
    str += tmpStr;
    if(atts->GetScaleCube())
        snprintf(tmpStr, 1000, "%sscaleCube = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sscaleCube = 0\n", prefix);
    str += tmpStr;
    const char *densityType_names = "Probability, ZoneCount";
    switch (atts->GetDensityType())
    {
      case PDFAttributes::Probability:
          snprintf(tmpStr, 1000, "%sdensityType = %sProbability  # %s\n", prefix, prefix, densityType_names);
          str += tmpStr;
          break;
      case PDFAttributes::ZoneCount:
          snprintf(tmpStr, 1000, "%sdensityType = %sZoneCount  # %s\n", prefix, prefix, densityType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    return str;
}

static PyObject *
PDFAttributes_Notify(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PDFAttributes_SetVar1(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the var1 in the object.
    obj->data->SetVar1(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PDFAttributes_GetVar1(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetVar1().c_str());
    return retval;
}

/*static*/ PyObject *
PDFAttributes_SetVar1MinFlag(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var1MinFlag in the object.
    obj->data->SetVar1MinFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PDFAttributes_GetVar1MinFlag(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetVar1MinFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PDFAttributes_SetVar1MaxFlag(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var1MaxFlag in the object.
    obj->data->SetVar1MaxFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PDFAttributes_GetVar1MaxFlag(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetVar1MaxFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PDFAttributes_SetVar1Min(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the var1Min in the object.
    obj->data->SetVar1Min(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PDFAttributes_GetVar1Min(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetVar1Min());
    return retval;
}

/*static*/ PyObject *
PDFAttributes_SetVar1Max(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the var1Max in the object.
    obj->data->SetVar1Max(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PDFAttributes_GetVar1Max(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetVar1Max());
    return retval;
}

/*static*/ PyObject *
PDFAttributes_SetVar1Scaling(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var1Scaling in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetVar1Scaling(PDFAttributes::Scaling(ival));
    else
    {
        fprintf(stderr, "An invalid var1Scaling value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Linear, Log, Skew.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PDFAttributes_GetVar1Scaling(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetVar1Scaling()));
    return retval;
}

/*static*/ PyObject *
PDFAttributes_SetVar1SkewFactor(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the var1SkewFactor in the object.
    obj->data->SetVar1SkewFactor(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PDFAttributes_GetVar1SkewFactor(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetVar1SkewFactor());
    return retval;
}

/*static*/ PyObject *
PDFAttributes_SetVar1NumSamples(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var1NumSamples in the object.
    obj->data->SetVar1NumSamples((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PDFAttributes_GetVar1NumSamples(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetVar1NumSamples()));
    return retval;
}

/*static*/ PyObject *
PDFAttributes_SetVar2(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the var2 in the object.
    obj->data->SetVar2(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PDFAttributes_GetVar2(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetVar2().c_str());
    return retval;
}

/*static*/ PyObject *
PDFAttributes_SetVar2MinFlag(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var2MinFlag in the object.
    obj->data->SetVar2MinFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PDFAttributes_GetVar2MinFlag(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetVar2MinFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PDFAttributes_SetVar2MaxFlag(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var2MaxFlag in the object.
    obj->data->SetVar2MaxFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PDFAttributes_GetVar2MaxFlag(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetVar2MaxFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PDFAttributes_SetVar2Min(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the var2Min in the object.
    obj->data->SetVar2Min(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PDFAttributes_GetVar2Min(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetVar2Min());
    return retval;
}

/*static*/ PyObject *
PDFAttributes_SetVar2Max(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the var2Max in the object.
    obj->data->SetVar2Max(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PDFAttributes_GetVar2Max(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetVar2Max());
    return retval;
}

/*static*/ PyObject *
PDFAttributes_SetVar2Scaling(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var2Scaling in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetVar2Scaling(PDFAttributes::Scaling(ival));
    else
    {
        fprintf(stderr, "An invalid var2Scaling value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Linear, Log, Skew.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PDFAttributes_GetVar2Scaling(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetVar2Scaling()));
    return retval;
}

/*static*/ PyObject *
PDFAttributes_SetVar2SkewFactor(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the var2SkewFactor in the object.
    obj->data->SetVar2SkewFactor(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PDFAttributes_GetVar2SkewFactor(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetVar2SkewFactor());
    return retval;
}

/*static*/ PyObject *
PDFAttributes_SetVar2NumSamples(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var2NumSamples in the object.
    obj->data->SetVar2NumSamples((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PDFAttributes_GetVar2NumSamples(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetVar2NumSamples()));
    return retval;
}

/*static*/ PyObject *
PDFAttributes_SetNumAxes(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numAxes in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetNumAxes(PDFAttributes::NumAxes(ival));
    else
    {
        fprintf(stderr, "An invalid numAxes value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Two, Three.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PDFAttributes_GetNumAxes(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNumAxes()));
    return retval;
}

/*static*/ PyObject *
PDFAttributes_SetVar3(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the var3 in the object.
    obj->data->SetVar3(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PDFAttributes_GetVar3(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetVar3().c_str());
    return retval;
}

/*static*/ PyObject *
PDFAttributes_SetVar3MinFlag(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var3MinFlag in the object.
    obj->data->SetVar3MinFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PDFAttributes_GetVar3MinFlag(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetVar3MinFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PDFAttributes_SetVar3MaxFlag(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var3MaxFlag in the object.
    obj->data->SetVar3MaxFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PDFAttributes_GetVar3MaxFlag(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetVar3MaxFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PDFAttributes_SetVar3Min(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the var3Min in the object.
    obj->data->SetVar3Min(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PDFAttributes_GetVar3Min(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetVar3Min());
    return retval;
}

/*static*/ PyObject *
PDFAttributes_SetVar3Max(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the var3Max in the object.
    obj->data->SetVar3Max(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PDFAttributes_GetVar3Max(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetVar3Max());
    return retval;
}

/*static*/ PyObject *
PDFAttributes_SetVar3Scaling(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var3Scaling in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetVar3Scaling(PDFAttributes::Scaling(ival));
    else
    {
        fprintf(stderr, "An invalid var3Scaling value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Linear, Log, Skew.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PDFAttributes_GetVar3Scaling(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetVar3Scaling()));
    return retval;
}

/*static*/ PyObject *
PDFAttributes_SetVar3SkewFactor(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the var3SkewFactor in the object.
    obj->data->SetVar3SkewFactor(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PDFAttributes_GetVar3SkewFactor(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetVar3SkewFactor());
    return retval;
}

/*static*/ PyObject *
PDFAttributes_SetVar3NumSamples(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var3NumSamples in the object.
    obj->data->SetVar3NumSamples((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PDFAttributes_GetVar3NumSamples(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetVar3NumSamples()));
    return retval;
}

/*static*/ PyObject *
PDFAttributes_SetScaleCube(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the scaleCube in the object.
    obj->data->SetScaleCube(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PDFAttributes_GetScaleCube(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetScaleCube()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PDFAttributes_SetDensityType(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the densityType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetDensityType(PDFAttributes::DensityType(ival));
    else
    {
        fprintf(stderr, "An invalid densityType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Probability, ZoneCount.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PDFAttributes_GetDensityType(PyObject *self, PyObject *args)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDensityType()));
    return retval;
}



PyMethodDef PyPDFAttributes_methods[PDFATTRIBUTES_NMETH] = {
    {"Notify", PDFAttributes_Notify, METH_VARARGS},
    {"SetVar1", PDFAttributes_SetVar1, METH_VARARGS},
    {"GetVar1", PDFAttributes_GetVar1, METH_VARARGS},
    {"SetVar1MinFlag", PDFAttributes_SetVar1MinFlag, METH_VARARGS},
    {"GetVar1MinFlag", PDFAttributes_GetVar1MinFlag, METH_VARARGS},
    {"SetVar1MaxFlag", PDFAttributes_SetVar1MaxFlag, METH_VARARGS},
    {"GetVar1MaxFlag", PDFAttributes_GetVar1MaxFlag, METH_VARARGS},
    {"SetVar1Min", PDFAttributes_SetVar1Min, METH_VARARGS},
    {"GetVar1Min", PDFAttributes_GetVar1Min, METH_VARARGS},
    {"SetVar1Max", PDFAttributes_SetVar1Max, METH_VARARGS},
    {"GetVar1Max", PDFAttributes_GetVar1Max, METH_VARARGS},
    {"SetVar1Scaling", PDFAttributes_SetVar1Scaling, METH_VARARGS},
    {"GetVar1Scaling", PDFAttributes_GetVar1Scaling, METH_VARARGS},
    {"SetVar1SkewFactor", PDFAttributes_SetVar1SkewFactor, METH_VARARGS},
    {"GetVar1SkewFactor", PDFAttributes_GetVar1SkewFactor, METH_VARARGS},
    {"SetVar1NumSamples", PDFAttributes_SetVar1NumSamples, METH_VARARGS},
    {"GetVar1NumSamples", PDFAttributes_GetVar1NumSamples, METH_VARARGS},
    {"SetVar2", PDFAttributes_SetVar2, METH_VARARGS},
    {"GetVar2", PDFAttributes_GetVar2, METH_VARARGS},
    {"SetVar2MinFlag", PDFAttributes_SetVar2MinFlag, METH_VARARGS},
    {"GetVar2MinFlag", PDFAttributes_GetVar2MinFlag, METH_VARARGS},
    {"SetVar2MaxFlag", PDFAttributes_SetVar2MaxFlag, METH_VARARGS},
    {"GetVar2MaxFlag", PDFAttributes_GetVar2MaxFlag, METH_VARARGS},
    {"SetVar2Min", PDFAttributes_SetVar2Min, METH_VARARGS},
    {"GetVar2Min", PDFAttributes_GetVar2Min, METH_VARARGS},
    {"SetVar2Max", PDFAttributes_SetVar2Max, METH_VARARGS},
    {"GetVar2Max", PDFAttributes_GetVar2Max, METH_VARARGS},
    {"SetVar2Scaling", PDFAttributes_SetVar2Scaling, METH_VARARGS},
    {"GetVar2Scaling", PDFAttributes_GetVar2Scaling, METH_VARARGS},
    {"SetVar2SkewFactor", PDFAttributes_SetVar2SkewFactor, METH_VARARGS},
    {"GetVar2SkewFactor", PDFAttributes_GetVar2SkewFactor, METH_VARARGS},
    {"SetVar2NumSamples", PDFAttributes_SetVar2NumSamples, METH_VARARGS},
    {"GetVar2NumSamples", PDFAttributes_GetVar2NumSamples, METH_VARARGS},
    {"SetNumAxes", PDFAttributes_SetNumAxes, METH_VARARGS},
    {"GetNumAxes", PDFAttributes_GetNumAxes, METH_VARARGS},
    {"SetVar3", PDFAttributes_SetVar3, METH_VARARGS},
    {"GetVar3", PDFAttributes_GetVar3, METH_VARARGS},
    {"SetVar3MinFlag", PDFAttributes_SetVar3MinFlag, METH_VARARGS},
    {"GetVar3MinFlag", PDFAttributes_GetVar3MinFlag, METH_VARARGS},
    {"SetVar3MaxFlag", PDFAttributes_SetVar3MaxFlag, METH_VARARGS},
    {"GetVar3MaxFlag", PDFAttributes_GetVar3MaxFlag, METH_VARARGS},
    {"SetVar3Min", PDFAttributes_SetVar3Min, METH_VARARGS},
    {"GetVar3Min", PDFAttributes_GetVar3Min, METH_VARARGS},
    {"SetVar3Max", PDFAttributes_SetVar3Max, METH_VARARGS},
    {"GetVar3Max", PDFAttributes_GetVar3Max, METH_VARARGS},
    {"SetVar3Scaling", PDFAttributes_SetVar3Scaling, METH_VARARGS},
    {"GetVar3Scaling", PDFAttributes_GetVar3Scaling, METH_VARARGS},
    {"SetVar3SkewFactor", PDFAttributes_SetVar3SkewFactor, METH_VARARGS},
    {"GetVar3SkewFactor", PDFAttributes_GetVar3SkewFactor, METH_VARARGS},
    {"SetVar3NumSamples", PDFAttributes_SetVar3NumSamples, METH_VARARGS},
    {"GetVar3NumSamples", PDFAttributes_GetVar3NumSamples, METH_VARARGS},
    {"SetScaleCube", PDFAttributes_SetScaleCube, METH_VARARGS},
    {"GetScaleCube", PDFAttributes_GetScaleCube, METH_VARARGS},
    {"SetDensityType", PDFAttributes_SetDensityType, METH_VARARGS},
    {"GetDensityType", PDFAttributes_GetDensityType, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
PDFAttributes_dealloc(PyObject *v)
{
   PDFAttributesObject *obj = (PDFAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
PDFAttributes_compare(PyObject *v, PyObject *w)
{
    PDFAttributes *a = ((PDFAttributesObject *)v)->data;
    PDFAttributes *b = ((PDFAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyPDFAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "var1") == 0)
        return PDFAttributes_GetVar1(self, NULL);
    if(strcmp(name, "var1MinFlag") == 0)
        return PDFAttributes_GetVar1MinFlag(self, NULL);
    if(strcmp(name, "var1MaxFlag") == 0)
        return PDFAttributes_GetVar1MaxFlag(self, NULL);
    if(strcmp(name, "var1Min") == 0)
        return PDFAttributes_GetVar1Min(self, NULL);
    if(strcmp(name, "var1Max") == 0)
        return PDFAttributes_GetVar1Max(self, NULL);
    if(strcmp(name, "var1Scaling") == 0)
        return PDFAttributes_GetVar1Scaling(self, NULL);
    if(strcmp(name, "Linear") == 0)
        return PyInt_FromLong(long(PDFAttributes::Linear));
    if(strcmp(name, "Log") == 0)
        return PyInt_FromLong(long(PDFAttributes::Log));
    if(strcmp(name, "Skew") == 0)
        return PyInt_FromLong(long(PDFAttributes::Skew));

    if(strcmp(name, "var1SkewFactor") == 0)
        return PDFAttributes_GetVar1SkewFactor(self, NULL);
    if(strcmp(name, "var1NumSamples") == 0)
        return PDFAttributes_GetVar1NumSamples(self, NULL);
    if(strcmp(name, "var2") == 0)
        return PDFAttributes_GetVar2(self, NULL);
    if(strcmp(name, "var2MinFlag") == 0)
        return PDFAttributes_GetVar2MinFlag(self, NULL);
    if(strcmp(name, "var2MaxFlag") == 0)
        return PDFAttributes_GetVar2MaxFlag(self, NULL);
    if(strcmp(name, "var2Min") == 0)
        return PDFAttributes_GetVar2Min(self, NULL);
    if(strcmp(name, "var2Max") == 0)
        return PDFAttributes_GetVar2Max(self, NULL);
    if(strcmp(name, "var2Scaling") == 0)
        return PDFAttributes_GetVar2Scaling(self, NULL);
    if(strcmp(name, "Linear") == 0)
        return PyInt_FromLong(long(PDFAttributes::Linear));
    if(strcmp(name, "Log") == 0)
        return PyInt_FromLong(long(PDFAttributes::Log));
    if(strcmp(name, "Skew") == 0)
        return PyInt_FromLong(long(PDFAttributes::Skew));

    if(strcmp(name, "var2SkewFactor") == 0)
        return PDFAttributes_GetVar2SkewFactor(self, NULL);
    if(strcmp(name, "var2NumSamples") == 0)
        return PDFAttributes_GetVar2NumSamples(self, NULL);
    if(strcmp(name, "numAxes") == 0)
        return PDFAttributes_GetNumAxes(self, NULL);
    if(strcmp(name, "Two") == 0)
        return PyInt_FromLong(long(PDFAttributes::Two));
    if(strcmp(name, "Three") == 0)
        return PyInt_FromLong(long(PDFAttributes::Three));

    if(strcmp(name, "var3") == 0)
        return PDFAttributes_GetVar3(self, NULL);
    if(strcmp(name, "var3MinFlag") == 0)
        return PDFAttributes_GetVar3MinFlag(self, NULL);
    if(strcmp(name, "var3MaxFlag") == 0)
        return PDFAttributes_GetVar3MaxFlag(self, NULL);
    if(strcmp(name, "var3Min") == 0)
        return PDFAttributes_GetVar3Min(self, NULL);
    if(strcmp(name, "var3Max") == 0)
        return PDFAttributes_GetVar3Max(self, NULL);
    if(strcmp(name, "var3Scaling") == 0)
        return PDFAttributes_GetVar3Scaling(self, NULL);
    if(strcmp(name, "Linear") == 0)
        return PyInt_FromLong(long(PDFAttributes::Linear));
    if(strcmp(name, "Log") == 0)
        return PyInt_FromLong(long(PDFAttributes::Log));
    if(strcmp(name, "Skew") == 0)
        return PyInt_FromLong(long(PDFAttributes::Skew));

    if(strcmp(name, "var3SkewFactor") == 0)
        return PDFAttributes_GetVar3SkewFactor(self, NULL);
    if(strcmp(name, "var3NumSamples") == 0)
        return PDFAttributes_GetVar3NumSamples(self, NULL);
    if(strcmp(name, "scaleCube") == 0)
        return PDFAttributes_GetScaleCube(self, NULL);
    if(strcmp(name, "densityType") == 0)
        return PDFAttributes_GetDensityType(self, NULL);
    if(strcmp(name, "Probability") == 0)
        return PyInt_FromLong(long(PDFAttributes::Probability));
    if(strcmp(name, "ZoneCount") == 0)
        return PyInt_FromLong(long(PDFAttributes::ZoneCount));


    return Py_FindMethod(PyPDFAttributes_methods, self, name);
}

int
PyPDFAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "var1") == 0)
        obj = PDFAttributes_SetVar1(self, tuple);
    else if(strcmp(name, "var1MinFlag") == 0)
        obj = PDFAttributes_SetVar1MinFlag(self, tuple);
    else if(strcmp(name, "var1MaxFlag") == 0)
        obj = PDFAttributes_SetVar1MaxFlag(self, tuple);
    else if(strcmp(name, "var1Min") == 0)
        obj = PDFAttributes_SetVar1Min(self, tuple);
    else if(strcmp(name, "var1Max") == 0)
        obj = PDFAttributes_SetVar1Max(self, tuple);
    else if(strcmp(name, "var1Scaling") == 0)
        obj = PDFAttributes_SetVar1Scaling(self, tuple);
    else if(strcmp(name, "var1SkewFactor") == 0)
        obj = PDFAttributes_SetVar1SkewFactor(self, tuple);
    else if(strcmp(name, "var1NumSamples") == 0)
        obj = PDFAttributes_SetVar1NumSamples(self, tuple);
    else if(strcmp(name, "var2") == 0)
        obj = PDFAttributes_SetVar2(self, tuple);
    else if(strcmp(name, "var2MinFlag") == 0)
        obj = PDFAttributes_SetVar2MinFlag(self, tuple);
    else if(strcmp(name, "var2MaxFlag") == 0)
        obj = PDFAttributes_SetVar2MaxFlag(self, tuple);
    else if(strcmp(name, "var2Min") == 0)
        obj = PDFAttributes_SetVar2Min(self, tuple);
    else if(strcmp(name, "var2Max") == 0)
        obj = PDFAttributes_SetVar2Max(self, tuple);
    else if(strcmp(name, "var2Scaling") == 0)
        obj = PDFAttributes_SetVar2Scaling(self, tuple);
    else if(strcmp(name, "var2SkewFactor") == 0)
        obj = PDFAttributes_SetVar2SkewFactor(self, tuple);
    else if(strcmp(name, "var2NumSamples") == 0)
        obj = PDFAttributes_SetVar2NumSamples(self, tuple);
    else if(strcmp(name, "numAxes") == 0)
        obj = PDFAttributes_SetNumAxes(self, tuple);
    else if(strcmp(name, "var3") == 0)
        obj = PDFAttributes_SetVar3(self, tuple);
    else if(strcmp(name, "var3MinFlag") == 0)
        obj = PDFAttributes_SetVar3MinFlag(self, tuple);
    else if(strcmp(name, "var3MaxFlag") == 0)
        obj = PDFAttributes_SetVar3MaxFlag(self, tuple);
    else if(strcmp(name, "var3Min") == 0)
        obj = PDFAttributes_SetVar3Min(self, tuple);
    else if(strcmp(name, "var3Max") == 0)
        obj = PDFAttributes_SetVar3Max(self, tuple);
    else if(strcmp(name, "var3Scaling") == 0)
        obj = PDFAttributes_SetVar3Scaling(self, tuple);
    else if(strcmp(name, "var3SkewFactor") == 0)
        obj = PDFAttributes_SetVar3SkewFactor(self, tuple);
    else if(strcmp(name, "var3NumSamples") == 0)
        obj = PDFAttributes_SetVar3NumSamples(self, tuple);
    else if(strcmp(name, "scaleCube") == 0)
        obj = PDFAttributes_SetScaleCube(self, tuple);
    else if(strcmp(name, "densityType") == 0)
        obj = PDFAttributes_SetDensityType(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
PDFAttributes_print(PyObject *v, FILE *fp, int flags)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)v;
    fprintf(fp, "%s", PyPDFAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
PDFAttributes_str(PyObject *v)
{
    PDFAttributesObject *obj = (PDFAttributesObject *)v;
    return PyString_FromString(PyPDFAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *PDFAttributes_Purpose = "Attributes for the PDF operator";
#else
static char *PDFAttributes_Purpose = "Attributes for the PDF operator";
#endif

//
// The type description structure
//
static PyTypeObject PDFAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "PDFAttributes",                    // tp_name
    sizeof(PDFAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)PDFAttributes_dealloc,  // tp_dealloc
    (printfunc)PDFAttributes_print,     // tp_print
    (getattrfunc)PyPDFAttributes_getattr, // tp_getattr
    (setattrfunc)PyPDFAttributes_setattr, // tp_setattr
    (cmpfunc)PDFAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)PDFAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    PDFAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static PDFAttributes *defaultAtts = 0;
static PDFAttributes *currentAtts = 0;

static PyObject *
NewPDFAttributes(int useCurrent)
{
    PDFAttributesObject *newObject;
    newObject = PyObject_NEW(PDFAttributesObject, &PDFAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new PDFAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new PDFAttributes(*defaultAtts);
    else
        newObject->data = new PDFAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapPDFAttributes(const PDFAttributes *attr)
{
    PDFAttributesObject *newObject;
    newObject = PyObject_NEW(PDFAttributesObject, &PDFAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (PDFAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
PDFAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewPDFAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef PDFAttributesMethods[] = {
    {"PDFAttributes", PDFAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *PDFAttributesObserver = 0;

std::string
PyPDFAttributes_GetLogString()
{
    std::string s("PDFAtts = PDFAttributes()\n");
    if(currentAtts != 0)
        s += PyPDFAttributes_ToString(currentAtts, "PDFAtts.");
    return s;
}

static void
PyPDFAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("PDFAtts = PDFAttributes()\n");
        s += PyPDFAttributes_ToString(currentAtts, "PDFAtts.");
        cb(s);
    }
}

void
PyPDFAttributes_StartUp(PDFAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyPDFAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(PDFAttributesObserver == 0)
    {
        PDFAttributesObserver = new ObserverToCallback(subj,
            PyPDFAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyPDFAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete PDFAttributesObserver;
    PDFAttributesObserver = 0;
}

PyMethodDef *
PyPDFAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return PDFAttributesMethods;
}

bool
PyPDFAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &PDFAttributesType);
}

PDFAttributes *
PyPDFAttributes_FromPyObject(PyObject *obj)
{
    PDFAttributesObject *obj2 = (PDFAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyPDFAttributes_New()
{
    return NewPDFAttributes(0);
}

PyObject *
PyPDFAttributes_Wrap(const PDFAttributes *attr)
{
    return WrapPDFAttributes(attr);
}

void
PyPDFAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    PDFAttributesObject *obj2 = (PDFAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyPDFAttributes_SetDefaults(const PDFAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new PDFAttributes(*atts);
}

