// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: PDFPluginInfo.h
// ****************************************************************************

#ifndef PDF_PLUGIN_INFO_H
#define PDF_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class PDFAttributes;

// ****************************************************************************
//  Class: PDFPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an PDF operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class PDFGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class PDFCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual PDFGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class PDFGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual PDFCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
};

class PDFViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual PDFCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static PDFAttributes *defaultAtts;
    static PDFAttributes *clientAtts;
};

class PDFViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual PDFViewerEnginePluginInfo
{
  public:
};

class PDFEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual PDFViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class PDFScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual PDFCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
