// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: PDFPluginInfo.C
// ****************************************************************************

#include <PDFPluginInfo.h>
#include <PDFAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(PDF,OP_EXPORT)

VISIT_OPERATOR_PLUGIN_ENTRY(PDF,General)

// ****************************************************************************
//  Method: PDFGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the operator plugin.
//
//  Returns:    A pointer to the name of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
PDFGeneralPluginInfo::GetName() const
{
    return "PDF";
}

// ****************************************************************************
//  Method: PDFGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the operator plugin.
//
//  Returns:    A pointer to the version of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
PDFGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: PDFGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the operator plugin.
//
//  Returns:    A pointer to the id of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
PDFGeneralPluginInfo::GetID() const
{
    return "PDF_1.0";
}
// ****************************************************************************
//  Method: PDFGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
PDFGeneralPluginInfo::EnabledByDefault() const
{
    return false;
}

// ****************************************************************************
//  Method: PDFGeneralPluginInfo::GetCategoryName
//
//  Purpose:
//    Return the category name to which the operator belongs.
//
//  Returns:    Return the category name to which the operator belongs.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
PDFGeneralPluginInfo::GetCategoryName() const
{
    return "Analysis";
}
