// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef ONIONPEELATTRIBUTES_H
#define ONIONPEELATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: OnionPeelAttributes
//
// Purpose:
//    Attributes for the onion peel operator
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class OnionPeelAttributes : public AttributeSubject
{
public:
    enum NodeFace
    {
        Node,
        Face
    };
    enum SeedIdType
    {
        SeedCell,
        SeedNode
    };

    // These constructors are for objects of this class
    OnionPeelAttributes();
    OnionPeelAttributes(const OnionPeelAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    OnionPeelAttributes(private_tmfs_t tmfs);
    OnionPeelAttributes(const OnionPeelAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~OnionPeelAttributes();

    virtual OnionPeelAttributes& operator = (const OnionPeelAttributes &obj);
    virtual bool operator == (const OnionPeelAttributes &obj) const;
    virtual bool operator != (const OnionPeelAttributes &obj) const;
private:
    void Init();
    void Copy(const OnionPeelAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectCategoryName();
    void SelectSubsetName();
    void SelectIndex();

    // Property setting methods
    void SetAdjacencyType(NodeFace adjacencyType_);
    void SetUseGlobalId(bool useGlobalId_);
    void SetCategoryName(const std::string &categoryName_);
    void SetSubsetName(const std::string &subsetName_);
    void SetIndex(const intVector &index_);
    void SetLogical(bool logical_);
    void SetRequestedLayer(int requestedLayer_);
    void SetSeedType(SeedIdType seedType_);
    void SetHonorOriginalMesh(bool honorOriginalMesh_);

    // Property getting methods
    NodeFace          GetAdjacencyType() const;
    bool              GetUseGlobalId() const;
    const std::string &GetCategoryName() const;
          std::string &GetCategoryName();
    const std::string &GetSubsetName() const;
          std::string &GetSubsetName();
    const intVector   &GetIndex() const;
          intVector   &GetIndex();
    bool              GetLogical() const;
    int               GetRequestedLayer() const;
    SeedIdType        GetSeedType() const;
    bool              GetHonorOriginalMesh() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string NodeFace_ToString(NodeFace);
    static bool NodeFace_FromString(const std::string &, NodeFace &);
protected:
    static std::string NodeFace_ToString(int);
public:
    static std::string SeedIdType_ToString(SeedIdType);
    static bool SeedIdType_FromString(const std::string &, SeedIdType &);
protected:
    static std::string SeedIdType_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_adjacencyType = 0,
        ID_useGlobalId,
        ID_categoryName,
        ID_subsetName,
        ID_index,
        ID_logical,
        ID_requestedLayer,
        ID_seedType,
        ID_honorOriginalMesh,
        ID__LAST
    };

private:
    int         adjacencyType;
    bool        useGlobalId;
    std::string categoryName;
    std::string subsetName;
    intVector   index;
    bool        logical;
    int         requestedLayer;
    int         seedType;
    bool        honorOriginalMesh;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define ONIONPEELATTRIBUTES_TMFS "ibssi*biib"

#endif
