// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISMULTIRESCONTROLWINDOW_H
#define QVISMULTIRESCONTROLWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>

class MultiresControlAttributes;
class QLabel;
class QSlider;

// ****************************************************************************
// Class: QvisMultiresControlWindow
//
// Purpose:
//    Defines QvisMultiresControlWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//
//   Tom Fogal,  Mon Aug 30 12:31:44 MDT 2010
//   Removed some dead/unused variables
//
// ****************************************************************************

class QvisMultiresControlWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisMultiresControlWindow(const int type,
                         MultiresControlAttributes *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisMultiresControlWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
  private slots:
    void resolutionLevelChanged(int val);
    void resolutionProcessText();
    void infoProcessText();
  private:
    QSlider* resolution;
    QLabel *resolutionLevelLabel;

    MultiresControlAttributes *atts;
};
#endif
