// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  MultiresControlScriptingPluginInfo.C
// ************************************************************************* //
#include <PyMultiresControlAttributes.h>
#include <MultiresControlPluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(MultiresControl,Scripting)

// ****************************************************************************
// Method: MultiresControlScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
MultiresControlScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyMultiresControlAttributes_StartUp((MultiresControlAttributes *)subj, data);
}

// ****************************************************************************
// Method: MultiresControlScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
MultiresControlScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyMultiresControlAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: MultiresControlScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is MultiresControl plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
MultiresControlScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyMultiresControlAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: MultiresControlScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
MultiresControlScriptingPluginInfo::GetLogString()
{
    std::string s(PyMultiresControlAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: MultiresControlScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
MultiresControlScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyMultiresControlAttributes_SetDefaults((const MultiresControlAttributes *)atts);
}
