// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: MultiresControlPluginInfo.C
// ****************************************************************************

#include <MultiresControlPluginInfo.h>
#include <MultiresControlAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(MultiresControl,OP_EXPORT)

VISIT_OPERATOR_PLUGIN_ENTRY(MultiresControl,General)

// ****************************************************************************
//  Method: MultiresControlGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the operator plugin.
//
//  Returns:    A pointer to the name of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
MultiresControlGeneralPluginInfo::GetName() const
{
    return "MultiresControl";
}

// ****************************************************************************
//  Method: MultiresControlGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the operator plugin.
//
//  Returns:    A pointer to the version of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
MultiresControlGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: MultiresControlGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the operator plugin.
//
//  Returns:    A pointer to the id of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
MultiresControlGeneralPluginInfo::GetID() const
{
    return "MultiresControl_1.0";
}
// ****************************************************************************
//  Method: MultiresControlGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
MultiresControlGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}

// ****************************************************************************
//  Method: MultiresControlGeneralPluginInfo::GetCategoryName
//
//  Purpose:
//    Return the category name to which the operator belongs.
//
//  Returns:    Return the category name to which the operator belongs.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
MultiresControlGeneralPluginInfo::GetCategoryName() const
{
    return "Selection";
}
