// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef MULTIRESCONTROLATTRIBUTES_H
#define MULTIRESCONTROLATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: MultiresControlAttributes
//
// Purpose:
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class MultiresControlAttributes : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    MultiresControlAttributes();
    MultiresControlAttributes(const MultiresControlAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    MultiresControlAttributes(private_tmfs_t tmfs);
    MultiresControlAttributes(const MultiresControlAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~MultiresControlAttributes();

    virtual MultiresControlAttributes& operator = (const MultiresControlAttributes &obj);
    virtual bool operator == (const MultiresControlAttributes &obj) const;
    virtual bool operator != (const MultiresControlAttributes &obj) const;
private:
    void Init();
    void Copy(const MultiresControlAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectInfo();

    // Property setting methods
    void SetResolution(int resolution_);
    void SetMaxResolution(int maxResolution_);
    void SetInfo(const std::string &info_);

    // Property getting methods
    int               GetResolution() const;
    int               GetMaxResolution() const;
    const std::string &GetInfo() const;
          std::string &GetInfo();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_resolution = 0,
        ID_maxResolution,
        ID_info,
        ID__LAST
    };

private:
    int         resolution;
    int         maxResolution;
    std::string info;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define MULTIRESCONTROLATTRIBUTES_TMFS "iis"

#endif
