// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISRELATVIEWWINDOW_H
#define QVISRELATVIEWWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>
#include <map>

#define VARS 0
#define TUPS 1
#define SOME 2

class ModelFitAtts;
class QvisVariableButton;
class QGroupBox;
class QRadioButton;
 
class QTableWidget;

class tableEntry 
{
  protected:
    int row;
    int col;
    std::string contents;
  
  public:
    tableEntry(int inRow, int inCol, std::string inString)
    {
        setRow(inRow);
        setCol(inCol);
        setContents(inString);
    }
    int getRow()
    {
        return row;
    }
    int getCol()
    {
        return col;
    }
    std::string getContents()
    {
        return contents;
    }
    void setRow(int inRow)
    {
        row = inRow;
    }
    void setCol(int inCol)
    {
        col = inCol;
    }
    void setContents(std::string inContents)
    {
        contents = inContents;
    }
};

// ****************************************************************************
// Class: QvisModelFitWindow
//
// Purpose:
//    Defines QvisModelFitWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

class QvisModelFitWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisModelFitWindow(const int type,
                         ModelFitAtts *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisModelFitWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
  private slots:
    void addRelationship();
    //void addSpaces();
    void varAdded(const QString&);
    void addTuple();
    void deleteVariable();
    void deletePoint();
    void deleteRelationship();
    void fillTables();
    void selectTypeChanged(int buttonID);
    void inputSpaceChanged(int buttonID);
    void distanceTypeChanged(int buttonID);
    void prepareTable(int, int, int, int);
    void storeTableContents(int, int);
    void storeModelNames(int, int);

  private:
    QPushButton *addRelat, *addTup, *deleteMod,  *deleteVar, *deleteTup;
    QvisVariableButton *addVar;
    //QvisVariableButton *addModel;
    QRadioButton *vSpace,    *nSpace,   *lSpace,    *pSpace,    *varSpace, 
                 *normSpace, *logSpace, *probSpace, *euclidean, *manhattan, *chebyshev;
    QStringList vHeaderLbls;
    QStringList hHeaderLbls;
    QGroupBox *distanceBox;
    QGroupBox *scoreBox;

    bool inPrepareTable;
    int cur_column;
    int cur_row;
    int tuple_number;
    int num_relats;
    intVector modelNumbers;
    intVector selection_type;
    intVector input_space;
    intVector distance_type;
    intVector numVars;
    intVector numPoints;
    stringVector modelNames;
    std::multimap<int, std::string>guiVarNames;
    std::multimap<int, tableEntry>theTable;
    int score_norm_type;

    QTableWidget *ModelFit;
    QTableWidget *models;

    ModelFitAtts *atts;
};



#endif
