// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ModelFitPluginInfo.C
// ****************************************************************************

#include <ModelFitPluginInfo.h>
#include <ModelFitAtts.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(ModelFit,OP_EXPORT)

VISIT_OPERATOR_PLUGIN_ENTRY(ModelFit,General)

// ****************************************************************************
//  Method: ModelFitGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the operator plugin.
//
//  Returns:    A pointer to the name of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ModelFitGeneralPluginInfo::GetName() const
{
    return "ModelFit";
}

// ****************************************************************************
//  Method: ModelFitGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the operator plugin.
//
//  Returns:    A pointer to the version of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ModelFitGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: ModelFitGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the operator plugin.
//
//  Returns:    A pointer to the id of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ModelFitGeneralPluginInfo::GetID() const
{
    return "ModelFit_1.0";
}
// ****************************************************************************
//  Method: ModelFitGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
ModelFitGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}

// ****************************************************************************
//  Method: ModelFitGeneralPluginInfo::GetCategoryName
//
//  Purpose:
//    Return the category name to which the operator belongs.
//
//  Returns:    Return the category name to which the operator belongs.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ModelFitGeneralPluginInfo::GetCategoryName() const
{
    return "Analysis";
}
