// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ModelFitCommonPluginInfo.C
// ****************************************************************************

#include <ModelFitPluginInfo.h>
#include <ModelFitAtts.h>

#include <Expression.h>
#include <ExpressionList.h>
#include <avtDatabaseMetaData.h>
#include <avtScalarMetaData.h>

// ****************************************************************************
//  Method: ModelFitCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
ModelFitCommonPluginInfo::AllocAttributes()
{
    return new ModelFitAtts;
}

// ****************************************************************************
//  Method: ModelFitCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a ModelFit attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ModelFitCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((ModelFitAtts *) to) = *((ModelFitAtts *) from);
}
// ****************************************************************************
// Method:  ModelFitCommonPluginInfo::GetCreatedExpressions
//
// Purpose:
//   Get the expressions this operator can generate.
//
// Arguments:
//   md         the metadata to create our expressions around
//
// Programmer:  Rob Sisneros
// Creation:    omitted
//
//  Modifications:
//   Jeremy Meredith, Thu Jan 12 13:28:49 EST 2012
//   Some files, like curves, don't have expressions.  Don't assume
//   we have any meshes in our file.
//
// ****************************************************************************
#include <string.h>

ExpressionList *
ModelFitCommonPluginInfo::GetCreatedExpressions(const avtDatabaseMetaData *md) const
{
    int numMeshes = md->GetNumMeshes();
    if (numMeshes == 0)
        return NULL;

    Expression *e = new Expression();

    char mesh[1024];
    strcpy(mesh, md->GetMesh(0)->name.c_str());

    std::string varname = "operators/ModelFit/model"; //(";
    //varname += mesh;
    //varname += ")";
    e->SetName(varname);
    char defn[1024];
    sprintf(defn, "point_constant(<%s>, 0)", mesh);
    e->SetDefinition(defn);
    e->SetMeshName(std::string(mesh));
    e->SetType(Expression::ScalarMeshVar);
    e->SetFromOperator(true);
    e->SetOperatorName("ModelFit");
    ExpressionList *expressions = new ExpressionList;
    expressions->AddExpressions(*e);
    delete e;

    e = new Expression();

    varname = "operators/ModelFit/distance"; //(";
    //varname += mesh;
    //varname += ")";
    e->SetName(varname);
    sprintf(defn, "point_constant(<%s>, 0)", mesh);
    e->SetDefinition(defn);
    e->SetMeshName(std::string(mesh));
    e->SetType(Expression::ScalarMeshVar);
    e->SetFromOperator(true);
    e->SetOperatorName("ModelFit");
    expressions->AddExpressions(*e);
    delete e;
    return expressions;
}

