// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: MetricThresholdViewerEnginePluginInfo.C
// ****************************************************************************

#include <MetricThresholdPluginInfo.h>
#include <MetricThresholdAttributes.h>

//
// Storage for static data elements.
//
MetricThresholdAttributes *MetricThresholdViewerEnginePluginInfo::clientAtts = NULL;
MetricThresholdAttributes *MetricThresholdViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  MetricThresholdViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
MetricThresholdViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (MetricThresholdViewerEnginePluginInfo::clientAtts == NULL)
    {
        MetricThresholdViewerEnginePluginInfo::clientAtts  = new MetricThresholdAttributes;
        MetricThresholdViewerEnginePluginInfo::defaultAtts = new MetricThresholdAttributes;
    }
}

// ****************************************************************************
//  Method: MetricThresholdViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
MetricThresholdViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: MetricThresholdViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
MetricThresholdViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: MetricThresholdViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
MetricThresholdViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(MetricThresholdAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: MetricThresholdViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
MetricThresholdViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(MetricThresholdAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: MetricThresholdViewerEnginePluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts        The attribute subject to initialize.
//    plot        The viewer plot that owns the operator.
//    fromDefault True to initialize the attributes from the defaults. False
//                to initialize from the current attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
MetricThresholdViewerEnginePluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const avtPlotMetaData &plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(MetricThresholdAttributes*)atts = *defaultAtts;
    else
        *(MetricThresholdAttributes*)atts = *clientAtts;

    UpdateOperatorAtts(atts, plot);
}

// ****************************************************************************
//  Method: MetricThresholdViewerEnginePluginInfo::UpdateOperatorAtts
//
//  Purpose:
//    Update the operator attributes when using operator expressions.
//
//  Arguments:
//    atts        The attribute subject to update.
//    plot        The viewer plot that owns the operator.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
MetricThresholdViewerEnginePluginInfo::UpdateOperatorAtts(AttributeSubject *atts, const avtPlotMetaData &plot)
{
}

// ****************************************************************************
//  Method: MetricThresholdViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
MetricThresholdViewerEnginePluginInfo::GetMenuName() const
{
    return "Metric Threshold";
}

