// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  MetricThresholdScriptingPluginInfo.C
// ************************************************************************* //
#include <PyMetricThresholdAttributes.h>
#include <MetricThresholdPluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(MetricThreshold,Scripting)

// ****************************************************************************
// Method: MetricThresholdScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
MetricThresholdScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyMetricThresholdAttributes_StartUp((MetricThresholdAttributes *)subj, data);
}

// ****************************************************************************
// Method: MetricThresholdScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
MetricThresholdScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyMetricThresholdAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: MetricThresholdScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is MetricThreshold plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
MetricThresholdScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyMetricThresholdAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: MetricThresholdScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
MetricThresholdScriptingPluginInfo::GetLogString()
{
    std::string s(PyMetricThresholdAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: MetricThresholdScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
MetricThresholdScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyMetricThresholdAttributes_SetDefaults((const MetricThresholdAttributes *)atts);
}
