// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: MetricThresholdGUIPluginInfo.C
// ****************************************************************************

#include <MetricThresholdPluginInfo.h>
#include <MetricThresholdAttributes.h>
#include <QApplication>
#include <QvisMetricThresholdWindow.h>

VISIT_OPERATOR_PLUGIN_ENTRY(MetricThreshold,GUI)

// ****************************************************************************
//  Method: MetricThresholdGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
MetricThresholdGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("OperatorNames", "Metric Threshold"));
}


// ****************************************************************************
//  Method: MetricThresholdGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
MetricThresholdGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisMetricThresholdWindow(type, (MetricThresholdAttributes *)attr,
        caption, shortName, notepad);
}

