// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef METRICTHRESHOLDATTRIBUTES_H
#define METRICTHRESHOLDATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: MetricThresholdAttributes
//
// Purpose:
//    This class contains attributes for the MetricThreshold operator.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class MetricThresholdAttributes : public AttributeSubject
{
public:
    enum Preset
    {
        None,
        Aspect_Ratio,
        Aspect_Gamma,
        Skew,
        Taper,
        Volume,
        Stretch,
        Diagonal,
        Dimension,
        Oddy,
        Condition,
        Jacobian,
        Scaled_Jacobian,
        Shear,
        Shape,
        Relative_Size,
        Shape_and_Size,
        Area,
        Warpage,
        Smallest_Angle,
        Largest_Angle
    };

    // These constructors are for objects of this class
    MetricThresholdAttributes();
    MetricThresholdAttributes(const MetricThresholdAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    MetricThresholdAttributes(private_tmfs_t tmfs);
    MetricThresholdAttributes(const MetricThresholdAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~MetricThresholdAttributes();

    virtual MetricThresholdAttributes& operator = (const MetricThresholdAttributes &obj);
    virtual bool operator == (const MetricThresholdAttributes &obj) const;
    virtual bool operator != (const MetricThresholdAttributes &obj) const;
private:
    void Init();
    void Copy(const MetricThresholdAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();

    // Property setting methods
    void SetPreset(Preset preset_);
    void SetHexahedron(bool Hexahedron_);
    void SetHex_lower(double hex_lower_);
    void SetHex_upper(double hex_upper_);
    void SetTetrahedron(bool Tetrahedron_);
    void SetTet_lower(double tet_lower_);
    void SetTet_upper(double tet_upper_);
    void SetWedge(bool Wedge_);
    void SetWed_lower(double wed_lower_);
    void SetWed_upper(double wed_upper_);
    void SetPyramid(bool Pyramid_);
    void SetPyr_lower(double pyr_lower_);
    void SetPyr_upper(double pyr_upper_);
    void SetTriangle(bool Triangle_);
    void SetTri_lower(double tri_lower_);
    void SetTri_upper(double tri_upper_);
    void SetQuad(bool Quad_);
    void SetQuad_lower(double quad_lower_);
    void SetQuad_upper(double quad_upper_);

    // Property getting methods
    Preset GetPreset() const;
    bool   GetHexahedron() const;
    double GetHex_lower() const;
    double GetHex_upper() const;
    bool   GetTetrahedron() const;
    double GetTet_lower() const;
    double GetTet_upper() const;
    bool   GetWedge() const;
    double GetWed_lower() const;
    double GetWed_upper() const;
    bool   GetPyramid() const;
    double GetPyr_lower() const;
    double GetPyr_upper() const;
    bool   GetTriangle() const;
    double GetTri_lower() const;
    double GetTri_upper() const;
    bool   GetQuad() const;
    double GetQuad_lower() const;
    double GetQuad_upper() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string Preset_ToString(Preset);
    static bool Preset_FromString(const std::string &, Preset &);
protected:
    static std::string Preset_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_preset = 0,
        ID_Hexahedron,
        ID_hex_lower,
        ID_hex_upper,
        ID_Tetrahedron,
        ID_tet_lower,
        ID_tet_upper,
        ID_Wedge,
        ID_wed_lower,
        ID_wed_upper,
        ID_Pyramid,
        ID_pyr_lower,
        ID_pyr_upper,
        ID_Triangle,
        ID_tri_lower,
        ID_tri_upper,
        ID_Quad,
        ID_quad_lower,
        ID_quad_upper,
        ID__LAST
    };

private:
    int    preset;
    bool   Hexahedron;
    double hex_lower;
    double hex_upper;
    bool   Tetrahedron;
    double tet_lower;
    double tet_upper;
    bool   Wedge;
    double wed_lower;
    double wed_upper;
    bool   Pyramid;
    double pyr_lower;
    double pyr_upper;
    bool   Triangle;
    double tri_lower;
    double tri_upper;
    bool   Quad;
    double quad_lower;
    double quad_upper;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define METRICTHRESHOLDATTRIBUTES_TMFS "ibddbddbddbddbddbdd"

#endif
