// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtMergeFilter.C
// ************************************************************************* //

#include <avtMergeFilter.h>

#include <avtCompactTreeFilter.h>


// ****************************************************************************
//  Method: avtMergeFilter constructor
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Aug 14 17:16:45 PST 2005
//
// ****************************************************************************

avtMergeFilter::avtMergeFilter()
{
    ctf = NULL;
}


// ****************************************************************************
//  Method: avtMergeFilter destructor
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Aug 14 17:16:45 PST 2005
//
//  Modifications:
//
// ****************************************************************************

avtMergeFilter::~avtMergeFilter()
{
    if (ctf != NULL)
    {
        delete ctf;
        ctf = NULL;
    }
}


// ****************************************************************************
//  Method:  avtMergeFilter::Create
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Aug 14 17:16:45 PST 2005
//
// ****************************************************************************

avtFilter *
avtMergeFilter::Create()
{
    return new avtMergeFilter();
}


// ****************************************************************************
//  Method:      avtMergeFilter::SetAtts
//
//  Purpose:
//      Sets the state of the filter based on the attribute object.
//
//  Arguments:
//      a        The attributes to use.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Aug 14 17:16:45 PST 2005
//
//  Modifications:
//
//    Hank Childs, Wed Aug 24 15:57:48 PDT 2005
//    Tell the compact tree filter to merge points as well.
//
//    Brad Whitlock, Wed Mar 19 14:14:53 PDT 2014
//    Add callback to the facade filter.
//
// ****************************************************************************

void
avtMergeFilter::SetAtts(const AttributeGroup *a)
{
    atts = *(const MergeOperatorAttributes*)a;

    ctf = new avtCompactTreeFilter();
    ctf->SetToleranceWhenCleaningPolyData(atts.GetTolerance());
    ctf->SetParallelMerge(atts.GetParallelMerge());
    ctf->CreateCleanPolyData(true);
    ctf->SetUpdateDataObjectInfoCallback(UpdateDataObjectInfoCB, (void*)this);
}


// ****************************************************************************
//  Method: avtMergeFilter::Equivalent
//
//  Purpose:
//      Returns true if creating a new avtMergeFilter with the given
//      parameters would result in an equivalent avtMergeFilter.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Aug 14 17:16:45 PST 2005
//
// ****************************************************************************

bool
avtMergeFilter::Equivalent(const AttributeGroup *a)
{
    return (atts == *(MergeOperatorAttributes*)a);
}


// ****************************************************************************
//  Method: avtMergeFilter::GetFacadedFilter
//
//  Purpose:
//      Gets the filter that we are a facade of.
//
//  Programmer: Hank Childs
//  Creation:   August 14, 2005
//
// ****************************************************************************

avtFilter *
avtMergeFilter::GetFacadedFilter(void)
{
    return ctf;
}


// ****************************************************************************
//  Method: avtMergeFilter::GetFacadedFilter
//
//  Purpose:
//      Gets the filter that we are a facade of.
//
//  Programmer: Tom Fogal
//  Creation:   June 23, 2009
//
// ****************************************************************************

const avtFilter *
avtMergeFilter::GetFacadedFilter(void) const
{
    return ctf;
}

// ****************************************************************************
// Method: avtMergeFilter::UpdateDataObjectInfoCB
//
// Purpose:
//   Update the data object information.
//
// Note:       Work partially supported by DOE Grant SC0007548.
//
// Programmer: Brad Whitlock
// Creation:   Tue Mar 18 10:53:05 PDT 2014
//
// Modifications:
//
// ****************************************************************************

void
avtMergeFilter::UpdateDataObjectInfoCB(avtDataObject_p &input,
    avtDataObject_p &output, void *This)
{
    avtDataAttributes &outAtts = output->GetInfo().GetAttributes();
    outAtts.AddFilterMetaData("Merge");
}
