// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISMERGEWINDOW_H
#define QVISMERGEWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>

class MergeOperatorAttributes;
class QLabel;
class QCheckBox;
class QLineEdit;

// ****************************************************************************
// Class: QvisMergeWindow
//
// Purpose:
//    Defines QvisMergeWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

class QvisMergeWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisMergeWindow(const int type,
                         MergeOperatorAttributes *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisMergeWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
  private slots:
    void parallelMergeChanged(bool val);
    void toleranceProcessText();
  private:
    QCheckBox *parallelMerge;
    QLineEdit *tolerance;
    QLabel *toleranceLabel;

    MergeOperatorAttributes *atts;
};



#endif
