// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <MergeOperatorAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: MergeOperatorAttributes::MergeOperatorAttributes
//
// Purpose:
//   Init utility for the MergeOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void MergeOperatorAttributes::Init()
{
    parallelMerge = false;
    tolerance = 0;

    MergeOperatorAttributes::SelectAll();
}

// ****************************************************************************
// Method: MergeOperatorAttributes::MergeOperatorAttributes
//
// Purpose:
//   Copy utility for the MergeOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void MergeOperatorAttributes::Copy(const MergeOperatorAttributes &obj)
{
    parallelMerge = obj.parallelMerge;
    tolerance = obj.tolerance;

    MergeOperatorAttributes::SelectAll();
}

// Type map format string
const char *MergeOperatorAttributes::TypeMapFormatString = MERGEOPERATORATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t MergeOperatorAttributes::TmfsStruct = {MERGEOPERATORATTRIBUTES_TMFS};


// ****************************************************************************
// Method: MergeOperatorAttributes::MergeOperatorAttributes
//
// Purpose:
//   Default constructor for the MergeOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

MergeOperatorAttributes::MergeOperatorAttributes() :
    AttributeSubject(MergeOperatorAttributes::TypeMapFormatString)
{
    MergeOperatorAttributes::Init();
}

// ****************************************************************************
// Method: MergeOperatorAttributes::MergeOperatorAttributes
//
// Purpose:
//   Constructor for the derived classes of MergeOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

MergeOperatorAttributes::MergeOperatorAttributes(private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    MergeOperatorAttributes::Init();
}

// ****************************************************************************
// Method: MergeOperatorAttributes::MergeOperatorAttributes
//
// Purpose:
//   Copy constructor for the MergeOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

MergeOperatorAttributes::MergeOperatorAttributes(const MergeOperatorAttributes &obj) :
    AttributeSubject(MergeOperatorAttributes::TypeMapFormatString)
{
    MergeOperatorAttributes::Copy(obj);
}

// ****************************************************************************
// Method: MergeOperatorAttributes::MergeOperatorAttributes
//
// Purpose:
//   Copy constructor for derived classes of the MergeOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

MergeOperatorAttributes::MergeOperatorAttributes(const MergeOperatorAttributes &obj, private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    MergeOperatorAttributes::Copy(obj);
}

// ****************************************************************************
// Method: MergeOperatorAttributes::~MergeOperatorAttributes
//
// Purpose:
//   Destructor for the MergeOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

MergeOperatorAttributes::~MergeOperatorAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: MergeOperatorAttributes::operator =
//
// Purpose:
//   Assignment operator for the MergeOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

MergeOperatorAttributes&
MergeOperatorAttributes::operator = (const MergeOperatorAttributes &obj)
{
    if (this == &obj) return *this;

    MergeOperatorAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: MergeOperatorAttributes::operator ==
//
// Purpose:
//   Comparison operator == for the MergeOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
MergeOperatorAttributes::operator == (const MergeOperatorAttributes &obj) const
{
    // Create the return value
    return ((parallelMerge == obj.parallelMerge) &&
            (tolerance == obj.tolerance));
}

// ****************************************************************************
// Method: MergeOperatorAttributes::operator !=
//
// Purpose:
//   Comparison operator != for the MergeOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
MergeOperatorAttributes::operator != (const MergeOperatorAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: MergeOperatorAttributes::TypeName
//
// Purpose:
//   Type name method for the MergeOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const std::string
MergeOperatorAttributes::TypeName() const
{
    return "MergeOperatorAttributes";
}

// ****************************************************************************
// Method: MergeOperatorAttributes::CopyAttributes
//
// Purpose:
//   CopyAttributes method for the MergeOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
MergeOperatorAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const MergeOperatorAttributes *tmp = (const MergeOperatorAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: MergeOperatorAttributes::CreateCompatible
//
// Purpose:
//   CreateCompatible method for the MergeOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
MergeOperatorAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new MergeOperatorAttributes(*this);
    // Other cases could go here too.

    return retval;
}

// ****************************************************************************
// Method: MergeOperatorAttributes::NewInstance
//
// Purpose:
//   NewInstance method for the MergeOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
MergeOperatorAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new MergeOperatorAttributes(*this);
    else
        retval = new MergeOperatorAttributes;

    return retval;
}

// ****************************************************************************
// Method: MergeOperatorAttributes::SelectAll
//
// Purpose:
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
MergeOperatorAttributes::SelectAll()
{
    Select(ID_parallelMerge, (void *)&parallelMerge);
    Select(ID_tolerance,     (void *)&tolerance);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: MergeOperatorAttributes::CreateNode
//
// Purpose:
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
MergeOperatorAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    MergeOperatorAttributes defaultObject;
    bool addToParent = false;
    // Create a node for MergeOperatorAttributes.
    DataNode *node = new DataNode("MergeOperatorAttributes");

    if(completeSave || !FieldsEqual(ID_parallelMerge, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("parallelMerge", parallelMerge));
    }

    if(completeSave || !FieldsEqual(ID_tolerance, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("tolerance", tolerance));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: MergeOperatorAttributes::SetFromNode
//
// Purpose:
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
MergeOperatorAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("MergeOperatorAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("parallelMerge")) != 0)
        SetParallelMerge(node->AsBool());
    if((node = searchNode->GetNode("tolerance")) != 0)
        SetTolerance(node->AsDouble());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
MergeOperatorAttributes::SetParallelMerge(bool parallelMerge_)
{
    parallelMerge = parallelMerge_;
    Select(ID_parallelMerge, (void *)&parallelMerge);
}

void
MergeOperatorAttributes::SetTolerance(double tolerance_)
{
    tolerance = tolerance_;
    Select(ID_tolerance, (void *)&tolerance);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
MergeOperatorAttributes::GetParallelMerge() const
{
    return parallelMerge;
}

double
MergeOperatorAttributes::GetTolerance() const
{
    return tolerance;
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: MergeOperatorAttributes::GetFieldName
//
// Purpose:
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
MergeOperatorAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_parallelMerge: return "parallelMerge";
    case ID_tolerance:     return "tolerance";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: MergeOperatorAttributes::GetFieldType
//
// Purpose:
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeGroup::FieldType
MergeOperatorAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_parallelMerge: return FieldType_bool;
    case ID_tolerance:     return FieldType_double;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: MergeOperatorAttributes::GetFieldTypeName
//
// Purpose:
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
MergeOperatorAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_parallelMerge: return "bool";
    case ID_tolerance:     return "double";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: MergeOperatorAttributes::FieldsEqual
//
// Purpose:
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
MergeOperatorAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const MergeOperatorAttributes &obj = *((const MergeOperatorAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_parallelMerge:
        {  // new scope
        retval = (parallelMerge == obj.parallelMerge);
        }
        break;
    case ID_tolerance:
        {  // new scope
        retval = (tolerance == obj.tolerance);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

