// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtLineoutPluginFilter.h
// ************************************************************************* //

#ifndef AVT_LineoutPlugin_FILTER_H
#define AVT_LineoutPlugin_FILTER_H


#include <avtPluginFilter.h>
#include <avtSingleFilterFacade.h>

#include <LineoutAttributes.h>

class     avtLineoutFilter;

// ****************************************************************************
//  Class: avtLineoutPluginFilter
//
//  Purpose:
//      A plugin operator for Lineout.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   January 24, 2008
//
//  Modifications:
//
//    Tom Fogal, Tue Jun 23 20:50:44 MDT 2009
//    Added const version of GetFacadedFilter.
//
// ****************************************************************************

class avtLineoutPluginFilter : virtual public avtPluginFilter,
                               virtual public avtSingleFilterFacade
{
  public:
                         avtLineoutPluginFilter();
    virtual             ~avtLineoutPluginFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtLineoutPluginFilter"; };
    virtual const char  *GetDescription(void)
                             { return "Lineout"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

  protected:
    avtLineoutFilter         *lineouter;
    LineoutAttributes         atts;

    virtual avtFilter        *GetFacadedFilter();
    virtual const avtFilter  *GetFacadedFilter() const;

    static void UpdateDataObjectInfoCB(avtDataObject_p &input,
                                       avtDataObject_p &output, void *);
};

#endif
