// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtLineoutPluginFilter.C
// ************************************************************************* //

#include <avtLineoutPluginFilter.h>

#include <avtLineoutFilter.h>
#include <LineoutAttributes.h>

// ****************************************************************************
//  Method: avtLineoutPluginFilter constructor
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   January 24, 2008
//
// ****************************************************************************

avtLineoutPluginFilter::avtLineoutPluginFilter()
{
    lineouter = NULL;
}


// ****************************************************************************
//  Method: avtLineoutPluginFilter destructor
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   January 24, 2008
//
//  Modifications:
//
// ****************************************************************************

avtLineoutPluginFilter::~avtLineoutPluginFilter()
{
    if (lineouter != NULL)
    {
        delete lineouter;
        lineouter = NULL;
    }
}


// ****************************************************************************
//  Method:  avtLineoutPluginFilter::Create
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   January 24, 2008
//
// ****************************************************************************

avtFilter *
avtLineoutPluginFilter::Create()
{
    return new avtLineoutPluginFilter();
}


// ****************************************************************************
//  Method:      avtLineoutPluginFilter::SetAtts
//
//  Purpose:
//      Sets the state of the filter based on the attribute object.
//
//  Arguments:
//      a        The attributes to use.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   January 24, 2008
//
//  Modifications:
//
//    Hank Childs, Fri Jan 25 09:59:29 PST 2008
//    Remove ignoreGlobal, which was unused.
//
//    Brad Whitlock, Wed Mar 19 14:14:53 PDT 2014
//    Add callback to the facade filter.
//
// ****************************************************************************

void
avtLineoutPluginFilter::SetAtts(const AttributeGroup *a)
{
    atts = *(const LineoutAttributes*)a;

    //
    // Construct a new resample filter based on these attributes.
    //
    if (lineouter != NULL)
    {
        delete lineouter;
    }

    lineouter = new avtLineoutFilter();
    lineouter->SetPoint1(atts.GetPoint1());
    lineouter->SetPoint2(atts.GetPoint2());
    lineouter->SetSamplingOn(atts.GetSamplingOn());
    lineouter->SetNumberOfSamplePoints(atts.GetNumberOfSamplePoints());
    lineouter->SetUpdateDataObjectInfoCallback(UpdateDataObjectInfoCB, (void*)this);
}


// ****************************************************************************
//  Method: avtLineoutPluginFilter::Equivalent
//
//  Purpose:
//      Returns true if creating a new avtLineoutPluginFilter with the given
//      parameters would result in an equivalent avtLineoutPluginFilter.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   January 24, 2008
//
// ****************************************************************************

bool
avtLineoutPluginFilter::Equivalent(const AttributeGroup *a)
{
    return (atts == *(LineoutAttributes*)a);
}


// ****************************************************************************
//  Method: avtLineoutPluginFilter::GetFacadedFilter
//
//  Purpose:
//      Gets the filter that the filter that we are a facade of.
//
//  Programmer: Hank Childs
//  Creation:   January 24, 2008
//
// ****************************************************************************

avtFilter *
avtLineoutPluginFilter::GetFacadedFilter(void)
{
    return lineouter;
}


// ****************************************************************************
//  Method: avtLineoutPluginFilter::GetFacadedFilter
//
//  Purpose:
//      Gets the filter that the filter that we are a facade of.
//
//  Programmer: Tom Fogal
//  Creation:   June 23, 2009
//
// ****************************************************************************

const avtFilter *
avtLineoutPluginFilter::GetFacadedFilter(void) const
{
    return lineouter;
}

// ****************************************************************************
// Method: avtLineoutPluginFilter::UpdateDataObjectInfoCB
//
// Purpose:
//   Update the data object information via a callback function.
//
// Note:       Work partially supported by DOE Grant SC0007548.
//
// Programmer: Brad Whitlock
// Creation:   Tue Mar 18 10:53:05 PDT 2014
//
// Modifications:
//
// ****************************************************************************

void
avtLineoutPluginFilter::UpdateDataObjectInfoCB(avtDataObject_p &input,
    avtDataObject_p &output, void *This)
{
    avtDataAttributes &outAtts = output->GetInfo().GetAttributes();
    const LineoutAttributes &lo = ((const avtLineoutPluginFilter *)This)->atts;

    char params[400];
    snprintf(params, 400, "point1=%lg,%lg,%lg point2=%lg,%lg,%lg", 
             lo.GetPoint1()[0],lo.GetPoint1()[1],lo.GetPoint1()[2],
             lo.GetPoint2()[0],lo.GetPoint2()[1],lo.GetPoint2()[2]);
    outAtts.AddFilterMetaData("Lineout", params);
}
