// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  LineoutScriptingPluginInfo.C
// ************************************************************************* //
#include <PyLineoutAttributes.h>
#include <LineoutPluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(Lineout,Scripting)

// ****************************************************************************
// Method: LineoutScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
LineoutScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyLineoutAttributes_StartUp((LineoutAttributes *)subj, data);
}

// ****************************************************************************
// Method: LineoutScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
LineoutScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyLineoutAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: LineoutScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is Lineout plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
LineoutScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyLineoutAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: LineoutScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
LineoutScriptingPluginInfo::GetLogString()
{
    std::string s(PyLineoutAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: LineoutScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
LineoutScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyLineoutAttributes_SetDefaults((const LineoutAttributes *)atts);
}
