// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: LineoutPluginInfo.h
// ****************************************************************************

#ifndef LINEOUT_PLUGIN_INFO_H
#define LINEOUT_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class LineoutAttributes;

// ****************************************************************************
//  Class: LineoutPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an Lineout operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class LineoutGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class LineoutCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual LineoutGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
    virtual bool GetUserSelectable() const;
    virtual int GetVariableTypes() const;
    virtual int GetVariableMask() const;
    virtual ExpressionList *GetCreatedExpressions(const avtDatabaseMetaData *) const;
};

class LineoutGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual LineoutCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
    virtual const char **XPMIconData() const;
};

class LineoutViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual LineoutCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;
    virtual bool Removeable() const;
    virtual bool Moveable() const;
    virtual bool AllowsSubsequentOperators() const;

    static void InitializeGlobalObjects();
  private:
    static LineoutAttributes *defaultAtts;
    static LineoutAttributes *clientAtts;
};

class LineoutViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual LineoutViewerEnginePluginInfo
{
  public:
    virtual const char **XPMIconData() const;
};

class LineoutEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual LineoutViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class LineoutScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual LineoutCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
