// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: LineoutGUIPluginInfo.C
// ****************************************************************************

#include <LineoutPluginInfo.h>
#include <LineoutAttributes.h>
#include <QApplication>
#include <QvisLineoutWindow.h>

VISIT_OPERATOR_PLUGIN_ENTRY(Lineout,GUI)

// ****************************************************************************
//  Method: LineoutGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
LineoutGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("OperatorNames", "Lineout"));
}


// ****************************************************************************
//  Method: LineoutGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
LineoutGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisLineoutWindow(type, (LineoutAttributes *)attr,
        caption, shortName, notepad);
}

// ****************************************************************************
//  Method: LineoutGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

#include <Lineout.xpm>
const char **
LineoutGUIPluginInfo::XPMIconData() const
{
    return Lineout_xpm;
}

