// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtLineSurfaceFilter.h
// ************************************************************************* //

#ifndef AVT_LineSurface_FILTER_H
#define AVT_LineSurface_FILTER_H


#include <avtPluginDatasetToDatasetFilter.h>
#include <avtTimeLoopFilter.h>
#include <LineSurfaceAttributes.h>


class vtkDataSet;


// ****************************************************************************
//  Class: avtLineSurfaceFilter
//
//  Purpose:
//      A plugin operator for LineSurface.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Wed Jan 23 11:30:14 PDT 2008
//
// ****************************************************************************

class avtLineSurfaceFilter : virtual public avtPluginDatasetToDatasetFilter, 
                             virtual public avtTimeLoopFilter
{
  public:
                         avtLineSurfaceFilter();
    virtual             ~avtLineSurfaceFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtLineSurfaceFilter"; };
    virtual const char  *GetDescription(void)
                             { return "LineSurface"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

  protected:
    LineSurfaceAttributes   atts;

    std::vector<vtkDataSet *> lineouts;

    virtual void            Execute();
    virtual void            CreateFinalOutput();
    virtual bool            ExecutionSuccessful(void) { return true; };
};


#endif


