// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include "QvisLineSurfaceWindow.h"

#include <LineSurfaceAttributes.h>

#include <QLabel>
#include <QLayout>
#include <QLineEdit>


// ****************************************************************************
// Method: QvisLineSurfaceWindow::QvisLineSurfaceWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisLineSurfaceWindow::QvisLineSurfaceWindow(const int type,
                         LineSurfaceAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisLineSurfaceWindow::~QvisLineSurfaceWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisLineSurfaceWindow::~QvisLineSurfaceWindow()
{
}


// ****************************************************************************
// Method: QvisLineSurfaceWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisLineSurfaceWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    startTimeLabel = new QLabel(tr("Index of first time slice"), central);
    mainLayout->addWidget(startTimeLabel,0,0);
    startTime = new QLineEdit(central);
    connect(startTime, SIGNAL(returnPressed()),
            this, SLOT(startTimeProcessText()));
    mainLayout->addWidget(startTime, 0,1);

    endTimeLabel = new QLabel(tr("Index of last time slice"), central);
    mainLayout->addWidget(endTimeLabel,1,0);
    endTime = new QLineEdit(central);
    connect(endTime, SIGNAL(returnPressed()),
            this, SLOT(endTimeProcessText()));
    mainLayout->addWidget(endTime, 1,1);

    strideLabel = new QLabel(tr("Stride through time slices"), central);
    mainLayout->addWidget(strideLabel,2,0);
    stride = new QLineEdit(central);
    connect(stride, SIGNAL(returnPressed()),
            this, SLOT(strideProcessText()));
    mainLayout->addWidget(stride, 2,1);

    point1Label = new QLabel(tr("Point 1"), central);
    mainLayout->addWidget(point1Label,3,0);
    point1 = new QLineEdit(central);
    connect(point1, SIGNAL(returnPressed()),
            this, SLOT(point1ProcessText()));
    mainLayout->addWidget(point1, 3,1);

    point2Label = new QLabel(tr("Point 2"), central);
    mainLayout->addWidget(point2Label,4,0);
    point2 = new QLineEdit(central);
    connect(point2, SIGNAL(returnPressed()),
            this, SLOT(point2ProcessText()));
    mainLayout->addWidget(point2, 4,1);

}


// ****************************************************************************
// Method: QvisLineSurfaceWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisLineSurfaceWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case LineSurfaceAttributes::ID_startTime:
            startTime->setText(IntToQString(atts->GetStartTime()));
            break;
          case LineSurfaceAttributes::ID_endTime:
            endTime->setText(IntToQString(atts->GetEndTime()));
            break;
          case LineSurfaceAttributes::ID_stride:
            stride->setText(IntToQString(atts->GetStride()));
            break;
          case LineSurfaceAttributes::ID_point1:
            point1->setText(DoublesToQString(atts->GetPoint1(), 3));
            break;
          case LineSurfaceAttributes::ID_point2:
            point2->setText(DoublesToQString(atts->GetPoint2(), 3));
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisLineSurfaceWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisLineSurfaceWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do startTime
    if(which_widget == LineSurfaceAttributes::ID_startTime || doAll)
    {
        int val;
        if(LineEditGetInt(startTime, val))
            atts->SetStartTime(val);
        else
        {
            ResettingError(tr("Index of first time slice"),
                IntToQString(atts->GetStartTime()));
            atts->SetStartTime(atts->GetStartTime());
        }
    }

    // Do endTime
    if(which_widget == LineSurfaceAttributes::ID_endTime || doAll)
    {
        int val;
        if(LineEditGetInt(endTime, val))
            atts->SetEndTime(val);
        else
        {
            ResettingError(tr("Index of last time slice"),
                IntToQString(atts->GetEndTime()));
            atts->SetEndTime(atts->GetEndTime());
        }
    }

    // Do stride
    if(which_widget == LineSurfaceAttributes::ID_stride || doAll)
    {
        int val;
        if(LineEditGetInt(stride, val))
            atts->SetStride(val);
        else
        {
            ResettingError(tr("Stride through time slices"),
                IntToQString(atts->GetStride()));
            atts->SetStride(atts->GetStride());
        }
    }

    // Do point1
    if(which_widget == LineSurfaceAttributes::ID_point1 || doAll)
    {
        double val[3];
        if(LineEditGetDoubles(point1, val, 3))
            atts->SetPoint1(val);
        else
        {
            ResettingError(tr("Point 1"),
                DoublesToQString(atts->GetPoint1(),3));
            atts->SetPoint1(atts->GetPoint1());
        }
    }

    // Do point2
    if(which_widget == LineSurfaceAttributes::ID_point2 || doAll)
    {
        double val[3];
        if(LineEditGetDoubles(point2, val, 3))
            atts->SetPoint2(val);
        else
        {
            ResettingError(tr("Point 2"),
                DoublesToQString(atts->GetPoint2(),3));
            atts->SetPoint2(atts->GetPoint2());
        }
    }

}


//
// Qt Slot functions
//


void
QvisLineSurfaceWindow::startTimeProcessText()
{
    GetCurrentValues(LineSurfaceAttributes::ID_startTime);
    Apply();
}


void
QvisLineSurfaceWindow::endTimeProcessText()
{
    GetCurrentValues(LineSurfaceAttributes::ID_endTime);
    Apply();
}


void
QvisLineSurfaceWindow::strideProcessText()
{
    GetCurrentValues(LineSurfaceAttributes::ID_stride);
    Apply();
}


void
QvisLineSurfaceWindow::point1ProcessText()
{
    GetCurrentValues(LineSurfaceAttributes::ID_point1);
    Apply();
}


void
QvisLineSurfaceWindow::point2ProcessText()
{
    GetCurrentValues(LineSurfaceAttributes::ID_point2);
    Apply();
}


