// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: LineSurfaceViewerEnginePluginInfo.C
// ****************************************************************************

#include <LineSurfacePluginInfo.h>
#include <LineSurfaceAttributes.h>

//
// Storage for static data elements.
//
LineSurfaceAttributes *LineSurfaceViewerEnginePluginInfo::clientAtts = NULL;
LineSurfaceAttributes *LineSurfaceViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  LineSurfaceViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
LineSurfaceViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (LineSurfaceViewerEnginePluginInfo::clientAtts == NULL)
    {
        LineSurfaceViewerEnginePluginInfo::clientAtts  = new LineSurfaceAttributes;
        LineSurfaceViewerEnginePluginInfo::defaultAtts = new LineSurfaceAttributes;
    }
}

// ****************************************************************************
//  Method: LineSurfaceViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
LineSurfaceViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: LineSurfaceViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
LineSurfaceViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: LineSurfaceViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
LineSurfaceViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(LineSurfaceAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: LineSurfaceViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
LineSurfaceViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(LineSurfaceAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: LineSurfaceViewerEnginePluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts        The attribute subject to initialize.
//    plot        The viewer plot that owns the operator.
//    fromDefault True to initialize the attributes from the defaults. False
//                to initialize from the current attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
LineSurfaceViewerEnginePluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const avtPlotMetaData &plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(LineSurfaceAttributes*)atts = *defaultAtts;
    else
        *(LineSurfaceAttributes*)atts = *clientAtts;

    UpdateOperatorAtts(atts, plot);
}

// ****************************************************************************
//  Method: LineSurfaceViewerEnginePluginInfo::UpdateOperatorAtts
//
//  Purpose:
//    Update the operator attributes when using operator expressions.
//
//  Arguments:
//    atts        The attribute subject to update.
//    plot        The viewer plot that owns the operator.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
LineSurfaceViewerEnginePluginInfo::UpdateOperatorAtts(AttributeSubject *atts, const avtPlotMetaData &plot)
{
}

// ****************************************************************************
//  Method: LineSurfaceViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
LineSurfaceViewerEnginePluginInfo::GetMenuName() const
{
    return "LineSurface";
}

