// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef LINESURFACEATTRIBUTES_H
#define LINESURFACEATTRIBUTES_H
#include <AttributeSubject.h>


// ****************************************************************************
// Class: LineSurfaceAttributes
//
// Purpose:
//    Attributes for the LineSurface operator
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class LineSurfaceAttributes : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    LineSurfaceAttributes();
    LineSurfaceAttributes(const LineSurfaceAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    LineSurfaceAttributes(private_tmfs_t tmfs);
    LineSurfaceAttributes(const LineSurfaceAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~LineSurfaceAttributes();

    virtual LineSurfaceAttributes& operator = (const LineSurfaceAttributes &obj);
    virtual bool operator == (const LineSurfaceAttributes &obj) const;
    virtual bool operator != (const LineSurfaceAttributes &obj) const;
private:
    void Init();
    void Copy(const LineSurfaceAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectPoint1();
    void SelectPoint2();

    // Property setting methods
    void SetStartTime(int startTime_);
    void SetEndTime(int endTime_);
    void SetStride(int stride_);
    void SetPoint1(const double *point1_);
    void SetPoint2(const double *point2_);

    // Property getting methods
    int          GetStartTime() const;
    int          GetEndTime() const;
    int          GetStride() const;
    const double *GetPoint1() const;
          double *GetPoint1();
    const double *GetPoint2() const;
          double *GetPoint2();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_startTime = 0,
        ID_endTime,
        ID_stride,
        ID_point1,
        ID_point2,
        ID__LAST
    };

private:
    int    startTime;
    int    endTime;
    int    stride;
    double point1[3];
    double point2[3];

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define LINESURFACEATTRIBUTES_TMFS "iiiDD"

#endif
