// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  LineSamplerScriptingPluginInfo.C
// ************************************************************************* //
#include <PyLineSamplerAttributes.h>
#include <LineSamplerPluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(LineSampler,Scripting)

// ****************************************************************************
// Method: LineSamplerScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
LineSamplerScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyLineSamplerAttributes_StartUp((LineSamplerAttributes *)subj, data);
}

// ****************************************************************************
// Method: LineSamplerScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
LineSamplerScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyLineSamplerAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: LineSamplerScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is LineSampler plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
LineSamplerScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyLineSamplerAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: LineSamplerScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
LineSamplerScriptingPluginInfo::GetLogString()
{
    std::string s(PyLineSamplerAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: LineSamplerScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
LineSamplerScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyLineSamplerAttributes_SetDefaults((const LineSamplerAttributes *)atts);
}
