// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyLimitCycleAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>

// ****************************************************************************
// Module: PyLimitCycleAttributes
//
// Purpose:
//   Attributes for the LimitCycle
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a LimitCycleAttributes.
//
struct LimitCycleAttributesObject
{
    PyObject_HEAD
    LimitCycleAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewLimitCycleAttributes(int);

std::string
PyLimitCycleAttributes_ToString(const LimitCycleAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    const char *sourceType_names = "SpecifiedLine, SpecifiedPlane";
    switch (atts->GetSourceType())
    {
      case LimitCycleAttributes::SpecifiedLine:
          snprintf(tmpStr, 1000, "%ssourceType = %sSpecifiedLine  # %s\n", prefix, prefix, sourceType_names);
          str += tmpStr;
          break;
      case LimitCycleAttributes::SpecifiedPlane:
          snprintf(tmpStr, 1000, "%ssourceType = %sSpecifiedPlane  # %s\n", prefix, prefix, sourceType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    {   const double *lineStart = atts->GetLineStart();
        snprintf(tmpStr, 1000, "%slineStart = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", lineStart[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *lineEnd = atts->GetLineEnd();
        snprintf(tmpStr, 1000, "%slineEnd = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", lineEnd[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *planeOrigin = atts->GetPlaneOrigin();
        snprintf(tmpStr, 1000, "%splaneOrigin = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", planeOrigin[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *planeNormal = atts->GetPlaneNormal();
        snprintf(tmpStr, 1000, "%splaneNormal = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", planeNormal[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *planeUpAxis = atts->GetPlaneUpAxis();
        snprintf(tmpStr, 1000, "%splaneUpAxis = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", planeUpAxis[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    snprintf(tmpStr, 1000, "%ssampleDensity0 = %d\n", prefix, atts->GetSampleDensity0());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%ssampleDensity1 = %d\n", prefix, atts->GetSampleDensity1());
    str += tmpStr;
    const char *dataValue_names = "Solid, SeedPointID, Speed, Vorticity, ArcLength, "
        "TimeAbsolute, TimeRelative, AverageDistanceFromSeed, CorrelationDistance, "
        "Difference, Variable";
    switch (atts->GetDataValue())
    {
      case LimitCycleAttributes::Solid:
          snprintf(tmpStr, 1000, "%sdataValue = %sSolid  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case LimitCycleAttributes::SeedPointID:
          snprintf(tmpStr, 1000, "%sdataValue = %sSeedPointID  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case LimitCycleAttributes::Speed:
          snprintf(tmpStr, 1000, "%sdataValue = %sSpeed  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case LimitCycleAttributes::Vorticity:
          snprintf(tmpStr, 1000, "%sdataValue = %sVorticity  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case LimitCycleAttributes::ArcLength:
          snprintf(tmpStr, 1000, "%sdataValue = %sArcLength  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case LimitCycleAttributes::TimeAbsolute:
          snprintf(tmpStr, 1000, "%sdataValue = %sTimeAbsolute  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case LimitCycleAttributes::TimeRelative:
          snprintf(tmpStr, 1000, "%sdataValue = %sTimeRelative  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case LimitCycleAttributes::AverageDistanceFromSeed:
          snprintf(tmpStr, 1000, "%sdataValue = %sAverageDistanceFromSeed  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case LimitCycleAttributes::CorrelationDistance:
          snprintf(tmpStr, 1000, "%sdataValue = %sCorrelationDistance  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case LimitCycleAttributes::Difference:
          snprintf(tmpStr, 1000, "%sdataValue = %sDifference  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case LimitCycleAttributes::Variable:
          snprintf(tmpStr, 1000, "%sdataValue = %sVariable  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    snprintf(tmpStr, 1000, "%sdataVariable = \"%s\"\n", prefix, atts->GetDataVariable().c_str());
    str += tmpStr;
    const char *integrationDirection_names = "Forward, Backward, Both, ForwardDirectionless, BackwardDirectionless, "
        "BothDirectionless";
    switch (atts->GetIntegrationDirection())
    {
      case LimitCycleAttributes::Forward:
          snprintf(tmpStr, 1000, "%sintegrationDirection = %sForward  # %s\n", prefix, prefix, integrationDirection_names);
          str += tmpStr;
          break;
      case LimitCycleAttributes::Backward:
          snprintf(tmpStr, 1000, "%sintegrationDirection = %sBackward  # %s\n", prefix, prefix, integrationDirection_names);
          str += tmpStr;
          break;
      case LimitCycleAttributes::Both:
          snprintf(tmpStr, 1000, "%sintegrationDirection = %sBoth  # %s\n", prefix, prefix, integrationDirection_names);
          str += tmpStr;
          break;
      case LimitCycleAttributes::ForwardDirectionless:
          snprintf(tmpStr, 1000, "%sintegrationDirection = %sForwardDirectionless  # %s\n", prefix, prefix, integrationDirection_names);
          str += tmpStr;
          break;
      case LimitCycleAttributes::BackwardDirectionless:
          snprintf(tmpStr, 1000, "%sintegrationDirection = %sBackwardDirectionless  # %s\n", prefix, prefix, integrationDirection_names);
          str += tmpStr;
          break;
      case LimitCycleAttributes::BothDirectionless:
          snprintf(tmpStr, 1000, "%sintegrationDirection = %sBothDirectionless  # %s\n", prefix, prefix, integrationDirection_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    snprintf(tmpStr, 1000, "%smaxSteps = %d\n", prefix, atts->GetMaxSteps());
    str += tmpStr;
    if(atts->GetTerminateByDistance())
        snprintf(tmpStr, 1000, "%sterminateByDistance = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sterminateByDistance = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%stermDistance = %g\n", prefix, atts->GetTermDistance());
    str += tmpStr;
    if(atts->GetTerminateByTime())
        snprintf(tmpStr, 1000, "%sterminateByTime = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sterminateByTime = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%stermTime = %g\n", prefix, atts->GetTermTime());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%smaxStepLength = %g\n", prefix, atts->GetMaxStepLength());
    str += tmpStr;
    if(atts->GetLimitMaximumTimestep())
        snprintf(tmpStr, 1000, "%slimitMaximumTimestep = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%slimitMaximumTimestep = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%smaxTimeStep = %g\n", prefix, atts->GetMaxTimeStep());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%srelTol = %g\n", prefix, atts->GetRelTol());
    str += tmpStr;
    const char *absTolSizeType_names = "Absolute, FractionOfBBox";
    switch (atts->GetAbsTolSizeType())
    {
      case LimitCycleAttributes::Absolute:
          snprintf(tmpStr, 1000, "%sabsTolSizeType = %sAbsolute  # %s\n", prefix, prefix, absTolSizeType_names);
          str += tmpStr;
          break;
      case LimitCycleAttributes::FractionOfBBox:
          snprintf(tmpStr, 1000, "%sabsTolSizeType = %sFractionOfBBox  # %s\n", prefix, prefix, absTolSizeType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    snprintf(tmpStr, 1000, "%sabsTolAbsolute = %g\n", prefix, atts->GetAbsTolAbsolute());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sabsTolBBox = %g\n", prefix, atts->GetAbsTolBBox());
    str += tmpStr;
    const char *fieldType_names = "Default, FlashField, M3DC12DField, M3DC13DField, Nek5000Field, "
        "NektarPPField, NIMRODField";
    switch (atts->GetFieldType())
    {
      case LimitCycleAttributes::Default:
          snprintf(tmpStr, 1000, "%sfieldType = %sDefault  # %s\n", prefix, prefix, fieldType_names);
          str += tmpStr;
          break;
      case LimitCycleAttributes::FlashField:
          snprintf(tmpStr, 1000, "%sfieldType = %sFlashField  # %s\n", prefix, prefix, fieldType_names);
          str += tmpStr;
          break;
      case LimitCycleAttributes::M3DC12DField:
          snprintf(tmpStr, 1000, "%sfieldType = %sM3DC12DField  # %s\n", prefix, prefix, fieldType_names);
          str += tmpStr;
          break;
      case LimitCycleAttributes::M3DC13DField:
          snprintf(tmpStr, 1000, "%sfieldType = %sM3DC13DField  # %s\n", prefix, prefix, fieldType_names);
          str += tmpStr;
          break;
      case LimitCycleAttributes::Nek5000Field:
          snprintf(tmpStr, 1000, "%sfieldType = %sNek5000Field  # %s\n", prefix, prefix, fieldType_names);
          str += tmpStr;
          break;
      case LimitCycleAttributes::NektarPPField:
          snprintf(tmpStr, 1000, "%sfieldType = %sNektarPPField  # %s\n", prefix, prefix, fieldType_names);
          str += tmpStr;
          break;
      case LimitCycleAttributes::NIMRODField:
          snprintf(tmpStr, 1000, "%sfieldType = %sNIMRODField  # %s\n", prefix, prefix, fieldType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    snprintf(tmpStr, 1000, "%sfieldConstant = %g\n", prefix, atts->GetFieldConstant());
    str += tmpStr;
    {   const double *velocitySource = atts->GetVelocitySource();
        snprintf(tmpStr, 1000, "%svelocitySource = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", velocitySource[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    const char *integrationType_names = "Euler, Leapfrog, DormandPrince, AdamsBashforth, RK4, "
        "M3DC12DIntegrator";
    switch (atts->GetIntegrationType())
    {
      case LimitCycleAttributes::Euler:
          snprintf(tmpStr, 1000, "%sintegrationType = %sEuler  # %s\n", prefix, prefix, integrationType_names);
          str += tmpStr;
          break;
      case LimitCycleAttributes::Leapfrog:
          snprintf(tmpStr, 1000, "%sintegrationType = %sLeapfrog  # %s\n", prefix, prefix, integrationType_names);
          str += tmpStr;
          break;
      case LimitCycleAttributes::DormandPrince:
          snprintf(tmpStr, 1000, "%sintegrationType = %sDormandPrince  # %s\n", prefix, prefix, integrationType_names);
          str += tmpStr;
          break;
      case LimitCycleAttributes::AdamsBashforth:
          snprintf(tmpStr, 1000, "%sintegrationType = %sAdamsBashforth  # %s\n", prefix, prefix, integrationType_names);
          str += tmpStr;
          break;
      case LimitCycleAttributes::RK4:
          snprintf(tmpStr, 1000, "%sintegrationType = %sRK4  # %s\n", prefix, prefix, integrationType_names);
          str += tmpStr;
          break;
      case LimitCycleAttributes::M3DC12DIntegrator:
          snprintf(tmpStr, 1000, "%sintegrationType = %sM3DC12DIntegrator  # %s\n", prefix, prefix, integrationType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *parallelizationAlgorithmType_names = "LoadOnDemand, ParallelStaticDomains, MasterSlave, VisItSelects";
    switch (atts->GetParallelizationAlgorithmType())
    {
      case LimitCycleAttributes::LoadOnDemand:
          snprintf(tmpStr, 1000, "%sparallelizationAlgorithmType = %sLoadOnDemand  # %s\n", prefix, prefix, parallelizationAlgorithmType_names);
          str += tmpStr;
          break;
      case LimitCycleAttributes::ParallelStaticDomains:
          snprintf(tmpStr, 1000, "%sparallelizationAlgorithmType = %sParallelStaticDomains  # %s\n", prefix, prefix, parallelizationAlgorithmType_names);
          str += tmpStr;
          break;
      case LimitCycleAttributes::MasterSlave:
          snprintf(tmpStr, 1000, "%sparallelizationAlgorithmType = %sMasterSlave  # %s\n", prefix, prefix, parallelizationAlgorithmType_names);
          str += tmpStr;
          break;
      case LimitCycleAttributes::VisItSelects:
          snprintf(tmpStr, 1000, "%sparallelizationAlgorithmType = %sVisItSelects  # %s\n", prefix, prefix, parallelizationAlgorithmType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    snprintf(tmpStr, 1000, "%smaxProcessCount = %d\n", prefix, atts->GetMaxProcessCount());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%smaxDomainCacheSize = %d\n", prefix, atts->GetMaxDomainCacheSize());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sworkGroupSize = %d\n", prefix, atts->GetWorkGroupSize());
    str += tmpStr;
    if(atts->GetPathlines())
        snprintf(tmpStr, 1000, "%spathlines = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%spathlines = 0\n", prefix);
    str += tmpStr;
    if(atts->GetPathlinesOverrideStartingTimeFlag())
        snprintf(tmpStr, 1000, "%spathlinesOverrideStartingTimeFlag = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%spathlinesOverrideStartingTimeFlag = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%spathlinesOverrideStartingTime = %g\n", prefix, atts->GetPathlinesOverrideStartingTime());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%spathlinesPeriod = %g\n", prefix, atts->GetPathlinesPeriod());
    str += tmpStr;
    const char *pathlinesCMFE_names = "CONN_CMFE, POS_CMFE";
    switch (atts->GetPathlinesCMFE())
    {
      case LimitCycleAttributes::CONN_CMFE:
          snprintf(tmpStr, 1000, "%spathlinesCMFE = %sCONN_CMFE  # %s\n", prefix, prefix, pathlinesCMFE_names);
          str += tmpStr;
          break;
      case LimitCycleAttributes::POS_CMFE:
          snprintf(tmpStr, 1000, "%spathlinesCMFE = %sPOS_CMFE  # %s\n", prefix, prefix, pathlinesCMFE_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    snprintf(tmpStr, 1000, "%ssampleDistance0 = %g\n", prefix, atts->GetSampleDistance0());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%ssampleDistance1 = %g\n", prefix, atts->GetSampleDistance1());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%ssampleDistance2 = %g\n", prefix, atts->GetSampleDistance2());
    str += tmpStr;
    if(atts->GetFillInterior())
        snprintf(tmpStr, 1000, "%sfillInterior = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sfillInterior = 0\n", prefix);
    str += tmpStr;
    if(atts->GetRandomSamples())
        snprintf(tmpStr, 1000, "%srandomSamples = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%srandomSamples = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%srandomSeed = %d\n", prefix, atts->GetRandomSeed());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%snumberOfRandomSamples = %d\n", prefix, atts->GetNumberOfRandomSamples());
    str += tmpStr;
    if(atts->GetForceNodeCenteredData())
        snprintf(tmpStr, 1000, "%sforceNodeCenteredData = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sforceNodeCenteredData = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%scycleTolerance = %g\n", prefix, atts->GetCycleTolerance());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%smaxIterations = %d\n", prefix, atts->GetMaxIterations());
    str += tmpStr;
    if(atts->GetShowPartialResults())
        snprintf(tmpStr, 1000, "%sshowPartialResults = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sshowPartialResults = 0\n", prefix);
    str += tmpStr;
    if(atts->GetShowReturnDistances())
        snprintf(tmpStr, 1000, "%sshowReturnDistances = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sshowReturnDistances = 0\n", prefix);
    str += tmpStr;
    if(atts->GetIssueAdvectionWarnings())
        snprintf(tmpStr, 1000, "%sissueAdvectionWarnings = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sissueAdvectionWarnings = 0\n", prefix);
    str += tmpStr;
    if(atts->GetIssueBoundaryWarnings())
        snprintf(tmpStr, 1000, "%sissueBoundaryWarnings = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sissueBoundaryWarnings = 0\n", prefix);
    str += tmpStr;
    if(atts->GetIssueTerminationWarnings())
        snprintf(tmpStr, 1000, "%sissueTerminationWarnings = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sissueTerminationWarnings = 0\n", prefix);
    str += tmpStr;
    if(atts->GetIssueStepsizeWarnings())
        snprintf(tmpStr, 1000, "%sissueStepsizeWarnings = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sissueStepsizeWarnings = 0\n", prefix);
    str += tmpStr;
    if(atts->GetIssueStiffnessWarnings())
        snprintf(tmpStr, 1000, "%sissueStiffnessWarnings = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sissueStiffnessWarnings = 0\n", prefix);
    str += tmpStr;
    if(atts->GetIssueCriticalPointsWarnings())
        snprintf(tmpStr, 1000, "%sissueCriticalPointsWarnings = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sissueCriticalPointsWarnings = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%scriticalPointThreshold = %g\n", prefix, atts->GetCriticalPointThreshold());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%scorrelationDistanceAngTol = %g\n", prefix, atts->GetCorrelationDistanceAngTol());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%scorrelationDistanceMinDistAbsolute = %g\n", prefix, atts->GetCorrelationDistanceMinDistAbsolute());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%scorrelationDistanceMinDistBBox = %g\n", prefix, atts->GetCorrelationDistanceMinDistBBox());
    str += tmpStr;
    const char *correlationDistanceMinDistType_names = "Absolute, FractionOfBBox";
    switch (atts->GetCorrelationDistanceMinDistType())
    {
      case LimitCycleAttributes::Absolute:
          snprintf(tmpStr, 1000, "%scorrelationDistanceMinDistType = %sAbsolute  # %s\n", prefix, prefix, correlationDistanceMinDistType_names);
          str += tmpStr;
          break;
      case LimitCycleAttributes::FractionOfBBox:
          snprintf(tmpStr, 1000, "%scorrelationDistanceMinDistType = %sFractionOfBBox  # %s\n", prefix, prefix, correlationDistanceMinDistType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    return str;
}

static PyObject *
LimitCycleAttributes_Notify(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_SetSourceType(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the sourceType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetSourceType(LimitCycleAttributes::SourceType(ival));
    else
    {
        fprintf(stderr, "An invalid sourceType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "SpecifiedLine, SpecifiedPlane.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetSourceType(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSourceType()));
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetLineStart(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    double *dvals = obj->data->GetLineStart();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the lineStart in the object as modified.
    obj->data->SelectLineStart();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetLineStart(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the lineStart.
    PyObject *retval = PyTuple_New(3);
    const double *lineStart = obj->data->GetLineStart();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(lineStart[i]));
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetLineEnd(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    double *dvals = obj->data->GetLineEnd();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the lineEnd in the object as modified.
    obj->data->SelectLineEnd();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetLineEnd(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the lineEnd.
    PyObject *retval = PyTuple_New(3);
    const double *lineEnd = obj->data->GetLineEnd();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(lineEnd[i]));
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetPlaneOrigin(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    double *dvals = obj->data->GetPlaneOrigin();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the planeOrigin in the object as modified.
    obj->data->SelectPlaneOrigin();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetPlaneOrigin(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the planeOrigin.
    PyObject *retval = PyTuple_New(3);
    const double *planeOrigin = obj->data->GetPlaneOrigin();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(planeOrigin[i]));
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetPlaneNormal(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    double *dvals = obj->data->GetPlaneNormal();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the planeNormal in the object as modified.
    obj->data->SelectPlaneNormal();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetPlaneNormal(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the planeNormal.
    PyObject *retval = PyTuple_New(3);
    const double *planeNormal = obj->data->GetPlaneNormal();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(planeNormal[i]));
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetPlaneUpAxis(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    double *dvals = obj->data->GetPlaneUpAxis();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the planeUpAxis in the object as modified.
    obj->data->SelectPlaneUpAxis();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetPlaneUpAxis(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the planeUpAxis.
    PyObject *retval = PyTuple_New(3);
    const double *planeUpAxis = obj->data->GetPlaneUpAxis();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(planeUpAxis[i]));
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetSampleDensity0(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the sampleDensity0 in the object.
    obj->data->SetSampleDensity0((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetSampleDensity0(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSampleDensity0()));
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetSampleDensity1(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the sampleDensity1 in the object.
    obj->data->SetSampleDensity1((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetSampleDensity1(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSampleDensity1()));
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetDataValue(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the dataValue in the object.
    if(ival >= 0 && ival < 11)
        obj->data->SetDataValue(LimitCycleAttributes::DataValue(ival));
    else
    {
        fprintf(stderr, "An invalid dataValue value was given. "
                        "Valid values are in the range of [0,10]. "
                        "You can also use the following names: "
                        "Solid, SeedPointID, Speed, Vorticity, ArcLength, "
                        "TimeAbsolute, TimeRelative, AverageDistanceFromSeed, CorrelationDistance, "
                        "Difference, Variable.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetDataValue(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDataValue()));
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetDataVariable(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the dataVariable in the object.
    obj->data->SetDataVariable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetDataVariable(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetDataVariable().c_str());
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetIntegrationDirection(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the integrationDirection in the object.
    if(ival >= 0 && ival < 6)
        obj->data->SetIntegrationDirection(LimitCycleAttributes::IntegrationDirection(ival));
    else
    {
        fprintf(stderr, "An invalid integrationDirection value was given. "
                        "Valid values are in the range of [0,5]. "
                        "You can also use the following names: "
                        "Forward, Backward, Both, ForwardDirectionless, BackwardDirectionless, "
                        "BothDirectionless.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetIntegrationDirection(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetIntegrationDirection()));
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetMaxSteps(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxSteps in the object.
    obj->data->SetMaxSteps((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetMaxSteps(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMaxSteps()));
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetTerminateByDistance(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the terminateByDistance in the object.
    obj->data->SetTerminateByDistance(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetTerminateByDistance(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetTerminateByDistance()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetTermDistance(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the termDistance in the object.
    obj->data->SetTermDistance(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetTermDistance(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetTermDistance());
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetTerminateByTime(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the terminateByTime in the object.
    obj->data->SetTerminateByTime(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetTerminateByTime(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetTerminateByTime()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetTermTime(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the termTime in the object.
    obj->data->SetTermTime(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetTermTime(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetTermTime());
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetMaxStepLength(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the maxStepLength in the object.
    obj->data->SetMaxStepLength(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetMaxStepLength(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMaxStepLength());
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetLimitMaximumTimestep(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the limitMaximumTimestep in the object.
    obj->data->SetLimitMaximumTimestep(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetLimitMaximumTimestep(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLimitMaximumTimestep()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetMaxTimeStep(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the maxTimeStep in the object.
    obj->data->SetMaxTimeStep(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetMaxTimeStep(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMaxTimeStep());
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetRelTol(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the relTol in the object.
    obj->data->SetRelTol(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetRelTol(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetRelTol());
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetAbsTolSizeType(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the absTolSizeType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetAbsTolSizeType(LimitCycleAttributes::SizeType(ival));
    else
    {
        fprintf(stderr, "An invalid absTolSizeType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Absolute, FractionOfBBox.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetAbsTolSizeType(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetAbsTolSizeType()));
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetAbsTolAbsolute(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the absTolAbsolute in the object.
    obj->data->SetAbsTolAbsolute(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetAbsTolAbsolute(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetAbsTolAbsolute());
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetAbsTolBBox(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the absTolBBox in the object.
    obj->data->SetAbsTolBBox(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetAbsTolBBox(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetAbsTolBBox());
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetFieldType(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the fieldType in the object.
    if(ival >= 0 && ival < 7)
        obj->data->SetFieldType(LimitCycleAttributes::FieldType(ival));
    else
    {
        fprintf(stderr, "An invalid fieldType value was given. "
                        "Valid values are in the range of [0,6]. "
                        "You can also use the following names: "
                        "Default, FlashField, M3DC12DField, M3DC13DField, Nek5000Field, "
                        "NektarPPField, NIMRODField.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetFieldType(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetFieldType()));
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetFieldConstant(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the fieldConstant in the object.
    obj->data->SetFieldConstant(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetFieldConstant(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetFieldConstant());
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetVelocitySource(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    double *dvals = obj->data->GetVelocitySource();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the velocitySource in the object as modified.
    obj->data->SelectVelocitySource();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetVelocitySource(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the velocitySource.
    PyObject *retval = PyTuple_New(3);
    const double *velocitySource = obj->data->GetVelocitySource();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(velocitySource[i]));
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetIntegrationType(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the integrationType in the object.
    if(ival >= 0 && ival < 6)
        obj->data->SetIntegrationType(LimitCycleAttributes::IntegrationType(ival));
    else
    {
        fprintf(stderr, "An invalid integrationType value was given. "
                        "Valid values are in the range of [0,5]. "
                        "You can also use the following names: "
                        "Euler, Leapfrog, DormandPrince, AdamsBashforth, RK4, "
                        "M3DC12DIntegrator.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetIntegrationType(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetIntegrationType()));
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetParallelizationAlgorithmType(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the parallelizationAlgorithmType in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetParallelizationAlgorithmType(LimitCycleAttributes::ParallelizationAlgorithmType(ival));
    else
    {
        fprintf(stderr, "An invalid parallelizationAlgorithmType value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "LoadOnDemand, ParallelStaticDomains, MasterSlave, VisItSelects.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetParallelizationAlgorithmType(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetParallelizationAlgorithmType()));
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetMaxProcessCount(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxProcessCount in the object.
    obj->data->SetMaxProcessCount((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetMaxProcessCount(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMaxProcessCount()));
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetMaxDomainCacheSize(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxDomainCacheSize in the object.
    obj->data->SetMaxDomainCacheSize((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetMaxDomainCacheSize(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMaxDomainCacheSize()));
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetWorkGroupSize(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the workGroupSize in the object.
    obj->data->SetWorkGroupSize((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetWorkGroupSize(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetWorkGroupSize()));
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetPathlines(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pathlines in the object.
    obj->data->SetPathlines(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetPathlines(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPathlines()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetPathlinesOverrideStartingTimeFlag(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pathlinesOverrideStartingTimeFlag in the object.
    obj->data->SetPathlinesOverrideStartingTimeFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetPathlinesOverrideStartingTimeFlag(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPathlinesOverrideStartingTimeFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetPathlinesOverrideStartingTime(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the pathlinesOverrideStartingTime in the object.
    obj->data->SetPathlinesOverrideStartingTime(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetPathlinesOverrideStartingTime(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPathlinesOverrideStartingTime());
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetPathlinesPeriod(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the pathlinesPeriod in the object.
    obj->data->SetPathlinesPeriod(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetPathlinesPeriod(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPathlinesPeriod());
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetPathlinesCMFE(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pathlinesCMFE in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetPathlinesCMFE(LimitCycleAttributes::PathlinesCMFE(ival));
    else
    {
        fprintf(stderr, "An invalid pathlinesCMFE value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "CONN_CMFE, POS_CMFE.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetPathlinesCMFE(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPathlinesCMFE()));
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetSampleDistance0(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the sampleDistance0 in the object.
    obj->data->SetSampleDistance0(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetSampleDistance0(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetSampleDistance0());
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetSampleDistance1(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the sampleDistance1 in the object.
    obj->data->SetSampleDistance1(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetSampleDistance1(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetSampleDistance1());
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetSampleDistance2(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the sampleDistance2 in the object.
    obj->data->SetSampleDistance2(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetSampleDistance2(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetSampleDistance2());
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetFillInterior(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the fillInterior in the object.
    obj->data->SetFillInterior(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetFillInterior(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetFillInterior()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetRandomSamples(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the randomSamples in the object.
    obj->data->SetRandomSamples(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetRandomSamples(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetRandomSamples()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetRandomSeed(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the randomSeed in the object.
    obj->data->SetRandomSeed((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetRandomSeed(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetRandomSeed()));
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetNumberOfRandomSamples(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numberOfRandomSamples in the object.
    obj->data->SetNumberOfRandomSamples((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetNumberOfRandomSamples(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNumberOfRandomSamples()));
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetForceNodeCenteredData(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the forceNodeCenteredData in the object.
    obj->data->SetForceNodeCenteredData(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetForceNodeCenteredData(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetForceNodeCenteredData()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetCycleTolerance(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the cycleTolerance in the object.
    obj->data->SetCycleTolerance(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetCycleTolerance(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetCycleTolerance());
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetMaxIterations(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxIterations in the object.
    obj->data->SetMaxIterations((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetMaxIterations(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMaxIterations()));
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetShowPartialResults(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showPartialResults in the object.
    obj->data->SetShowPartialResults(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetShowPartialResults(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowPartialResults()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetShowReturnDistances(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showReturnDistances in the object.
    obj->data->SetShowReturnDistances(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetShowReturnDistances(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowReturnDistances()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetIssueAdvectionWarnings(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the issueAdvectionWarnings in the object.
    obj->data->SetIssueAdvectionWarnings(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetIssueAdvectionWarnings(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIssueAdvectionWarnings()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetIssueBoundaryWarnings(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the issueBoundaryWarnings in the object.
    obj->data->SetIssueBoundaryWarnings(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetIssueBoundaryWarnings(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIssueBoundaryWarnings()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetIssueTerminationWarnings(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the issueTerminationWarnings in the object.
    obj->data->SetIssueTerminationWarnings(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetIssueTerminationWarnings(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIssueTerminationWarnings()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetIssueStepsizeWarnings(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the issueStepsizeWarnings in the object.
    obj->data->SetIssueStepsizeWarnings(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetIssueStepsizeWarnings(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIssueStepsizeWarnings()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetIssueStiffnessWarnings(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the issueStiffnessWarnings in the object.
    obj->data->SetIssueStiffnessWarnings(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetIssueStiffnessWarnings(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIssueStiffnessWarnings()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetIssueCriticalPointsWarnings(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the issueCriticalPointsWarnings in the object.
    obj->data->SetIssueCriticalPointsWarnings(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetIssueCriticalPointsWarnings(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIssueCriticalPointsWarnings()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetCriticalPointThreshold(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the criticalPointThreshold in the object.
    obj->data->SetCriticalPointThreshold(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetCriticalPointThreshold(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetCriticalPointThreshold());
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetCorrelationDistanceAngTol(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the correlationDistanceAngTol in the object.
    obj->data->SetCorrelationDistanceAngTol(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetCorrelationDistanceAngTol(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetCorrelationDistanceAngTol());
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetCorrelationDistanceMinDistAbsolute(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the correlationDistanceMinDistAbsolute in the object.
    obj->data->SetCorrelationDistanceMinDistAbsolute(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetCorrelationDistanceMinDistAbsolute(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetCorrelationDistanceMinDistAbsolute());
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetCorrelationDistanceMinDistBBox(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the correlationDistanceMinDistBBox in the object.
    obj->data->SetCorrelationDistanceMinDistBBox(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetCorrelationDistanceMinDistBBox(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetCorrelationDistanceMinDistBBox());
    return retval;
}

/*static*/ PyObject *
LimitCycleAttributes_SetCorrelationDistanceMinDistType(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the correlationDistanceMinDistType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetCorrelationDistanceMinDistType(LimitCycleAttributes::SizeType(ival));
    else
    {
        fprintf(stderr, "An invalid correlationDistanceMinDistType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Absolute, FractionOfBBox.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LimitCycleAttributes_GetCorrelationDistanceMinDistType(PyObject *self, PyObject *args)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetCorrelationDistanceMinDistType()));
    return retval;
}



PyMethodDef PyLimitCycleAttributes_methods[LIMITCYCLEATTRIBUTES_NMETH] = {
    {"Notify", LimitCycleAttributes_Notify, METH_VARARGS},
    {"SetSourceType", LimitCycleAttributes_SetSourceType, METH_VARARGS},
    {"GetSourceType", LimitCycleAttributes_GetSourceType, METH_VARARGS},
    {"SetLineStart", LimitCycleAttributes_SetLineStart, METH_VARARGS},
    {"GetLineStart", LimitCycleAttributes_GetLineStart, METH_VARARGS},
    {"SetLineEnd", LimitCycleAttributes_SetLineEnd, METH_VARARGS},
    {"GetLineEnd", LimitCycleAttributes_GetLineEnd, METH_VARARGS},
    {"SetPlaneOrigin", LimitCycleAttributes_SetPlaneOrigin, METH_VARARGS},
    {"GetPlaneOrigin", LimitCycleAttributes_GetPlaneOrigin, METH_VARARGS},
    {"SetPlaneNormal", LimitCycleAttributes_SetPlaneNormal, METH_VARARGS},
    {"GetPlaneNormal", LimitCycleAttributes_GetPlaneNormal, METH_VARARGS},
    {"SetPlaneUpAxis", LimitCycleAttributes_SetPlaneUpAxis, METH_VARARGS},
    {"GetPlaneUpAxis", LimitCycleAttributes_GetPlaneUpAxis, METH_VARARGS},
    {"SetSampleDensity0", LimitCycleAttributes_SetSampleDensity0, METH_VARARGS},
    {"GetSampleDensity0", LimitCycleAttributes_GetSampleDensity0, METH_VARARGS},
    {"SetSampleDensity1", LimitCycleAttributes_SetSampleDensity1, METH_VARARGS},
    {"GetSampleDensity1", LimitCycleAttributes_GetSampleDensity1, METH_VARARGS},
    {"SetDataValue", LimitCycleAttributes_SetDataValue, METH_VARARGS},
    {"GetDataValue", LimitCycleAttributes_GetDataValue, METH_VARARGS},
    {"SetDataVariable", LimitCycleAttributes_SetDataVariable, METH_VARARGS},
    {"GetDataVariable", LimitCycleAttributes_GetDataVariable, METH_VARARGS},
    {"SetIntegrationDirection", LimitCycleAttributes_SetIntegrationDirection, METH_VARARGS},
    {"GetIntegrationDirection", LimitCycleAttributes_GetIntegrationDirection, METH_VARARGS},
    {"SetMaxSteps", LimitCycleAttributes_SetMaxSteps, METH_VARARGS},
    {"GetMaxSteps", LimitCycleAttributes_GetMaxSteps, METH_VARARGS},
    {"SetTerminateByDistance", LimitCycleAttributes_SetTerminateByDistance, METH_VARARGS},
    {"GetTerminateByDistance", LimitCycleAttributes_GetTerminateByDistance, METH_VARARGS},
    {"SetTermDistance", LimitCycleAttributes_SetTermDistance, METH_VARARGS},
    {"GetTermDistance", LimitCycleAttributes_GetTermDistance, METH_VARARGS},
    {"SetTerminateByTime", LimitCycleAttributes_SetTerminateByTime, METH_VARARGS},
    {"GetTerminateByTime", LimitCycleAttributes_GetTerminateByTime, METH_VARARGS},
    {"SetTermTime", LimitCycleAttributes_SetTermTime, METH_VARARGS},
    {"GetTermTime", LimitCycleAttributes_GetTermTime, METH_VARARGS},
    {"SetMaxStepLength", LimitCycleAttributes_SetMaxStepLength, METH_VARARGS},
    {"GetMaxStepLength", LimitCycleAttributes_GetMaxStepLength, METH_VARARGS},
    {"SetLimitMaximumTimestep", LimitCycleAttributes_SetLimitMaximumTimestep, METH_VARARGS},
    {"GetLimitMaximumTimestep", LimitCycleAttributes_GetLimitMaximumTimestep, METH_VARARGS},
    {"SetMaxTimeStep", LimitCycleAttributes_SetMaxTimeStep, METH_VARARGS},
    {"GetMaxTimeStep", LimitCycleAttributes_GetMaxTimeStep, METH_VARARGS},
    {"SetRelTol", LimitCycleAttributes_SetRelTol, METH_VARARGS},
    {"GetRelTol", LimitCycleAttributes_GetRelTol, METH_VARARGS},
    {"SetAbsTolSizeType", LimitCycleAttributes_SetAbsTolSizeType, METH_VARARGS},
    {"GetAbsTolSizeType", LimitCycleAttributes_GetAbsTolSizeType, METH_VARARGS},
    {"SetAbsTolAbsolute", LimitCycleAttributes_SetAbsTolAbsolute, METH_VARARGS},
    {"GetAbsTolAbsolute", LimitCycleAttributes_GetAbsTolAbsolute, METH_VARARGS},
    {"SetAbsTolBBox", LimitCycleAttributes_SetAbsTolBBox, METH_VARARGS},
    {"GetAbsTolBBox", LimitCycleAttributes_GetAbsTolBBox, METH_VARARGS},
    {"SetFieldType", LimitCycleAttributes_SetFieldType, METH_VARARGS},
    {"GetFieldType", LimitCycleAttributes_GetFieldType, METH_VARARGS},
    {"SetFieldConstant", LimitCycleAttributes_SetFieldConstant, METH_VARARGS},
    {"GetFieldConstant", LimitCycleAttributes_GetFieldConstant, METH_VARARGS},
    {"SetVelocitySource", LimitCycleAttributes_SetVelocitySource, METH_VARARGS},
    {"GetVelocitySource", LimitCycleAttributes_GetVelocitySource, METH_VARARGS},
    {"SetIntegrationType", LimitCycleAttributes_SetIntegrationType, METH_VARARGS},
    {"GetIntegrationType", LimitCycleAttributes_GetIntegrationType, METH_VARARGS},
    {"SetParallelizationAlgorithmType", LimitCycleAttributes_SetParallelizationAlgorithmType, METH_VARARGS},
    {"GetParallelizationAlgorithmType", LimitCycleAttributes_GetParallelizationAlgorithmType, METH_VARARGS},
    {"SetMaxProcessCount", LimitCycleAttributes_SetMaxProcessCount, METH_VARARGS},
    {"GetMaxProcessCount", LimitCycleAttributes_GetMaxProcessCount, METH_VARARGS},
    {"SetMaxDomainCacheSize", LimitCycleAttributes_SetMaxDomainCacheSize, METH_VARARGS},
    {"GetMaxDomainCacheSize", LimitCycleAttributes_GetMaxDomainCacheSize, METH_VARARGS},
    {"SetWorkGroupSize", LimitCycleAttributes_SetWorkGroupSize, METH_VARARGS},
    {"GetWorkGroupSize", LimitCycleAttributes_GetWorkGroupSize, METH_VARARGS},
    {"SetPathlines", LimitCycleAttributes_SetPathlines, METH_VARARGS},
    {"GetPathlines", LimitCycleAttributes_GetPathlines, METH_VARARGS},
    {"SetPathlinesOverrideStartingTimeFlag", LimitCycleAttributes_SetPathlinesOverrideStartingTimeFlag, METH_VARARGS},
    {"GetPathlinesOverrideStartingTimeFlag", LimitCycleAttributes_GetPathlinesOverrideStartingTimeFlag, METH_VARARGS},
    {"SetPathlinesOverrideStartingTime", LimitCycleAttributes_SetPathlinesOverrideStartingTime, METH_VARARGS},
    {"GetPathlinesOverrideStartingTime", LimitCycleAttributes_GetPathlinesOverrideStartingTime, METH_VARARGS},
    {"SetPathlinesPeriod", LimitCycleAttributes_SetPathlinesPeriod, METH_VARARGS},
    {"GetPathlinesPeriod", LimitCycleAttributes_GetPathlinesPeriod, METH_VARARGS},
    {"SetPathlinesCMFE", LimitCycleAttributes_SetPathlinesCMFE, METH_VARARGS},
    {"GetPathlinesCMFE", LimitCycleAttributes_GetPathlinesCMFE, METH_VARARGS},
    {"SetSampleDistance0", LimitCycleAttributes_SetSampleDistance0, METH_VARARGS},
    {"GetSampleDistance0", LimitCycleAttributes_GetSampleDistance0, METH_VARARGS},
    {"SetSampleDistance1", LimitCycleAttributes_SetSampleDistance1, METH_VARARGS},
    {"GetSampleDistance1", LimitCycleAttributes_GetSampleDistance1, METH_VARARGS},
    {"SetSampleDistance2", LimitCycleAttributes_SetSampleDistance2, METH_VARARGS},
    {"GetSampleDistance2", LimitCycleAttributes_GetSampleDistance2, METH_VARARGS},
    {"SetFillInterior", LimitCycleAttributes_SetFillInterior, METH_VARARGS},
    {"GetFillInterior", LimitCycleAttributes_GetFillInterior, METH_VARARGS},
    {"SetRandomSamples", LimitCycleAttributes_SetRandomSamples, METH_VARARGS},
    {"GetRandomSamples", LimitCycleAttributes_GetRandomSamples, METH_VARARGS},
    {"SetRandomSeed", LimitCycleAttributes_SetRandomSeed, METH_VARARGS},
    {"GetRandomSeed", LimitCycleAttributes_GetRandomSeed, METH_VARARGS},
    {"SetNumberOfRandomSamples", LimitCycleAttributes_SetNumberOfRandomSamples, METH_VARARGS},
    {"GetNumberOfRandomSamples", LimitCycleAttributes_GetNumberOfRandomSamples, METH_VARARGS},
    {"SetForceNodeCenteredData", LimitCycleAttributes_SetForceNodeCenteredData, METH_VARARGS},
    {"GetForceNodeCenteredData", LimitCycleAttributes_GetForceNodeCenteredData, METH_VARARGS},
    {"SetCycleTolerance", LimitCycleAttributes_SetCycleTolerance, METH_VARARGS},
    {"GetCycleTolerance", LimitCycleAttributes_GetCycleTolerance, METH_VARARGS},
    {"SetMaxIterations", LimitCycleAttributes_SetMaxIterations, METH_VARARGS},
    {"GetMaxIterations", LimitCycleAttributes_GetMaxIterations, METH_VARARGS},
    {"SetShowPartialResults", LimitCycleAttributes_SetShowPartialResults, METH_VARARGS},
    {"GetShowPartialResults", LimitCycleAttributes_GetShowPartialResults, METH_VARARGS},
    {"SetShowReturnDistances", LimitCycleAttributes_SetShowReturnDistances, METH_VARARGS},
    {"GetShowReturnDistances", LimitCycleAttributes_GetShowReturnDistances, METH_VARARGS},
    {"SetIssueAdvectionWarnings", LimitCycleAttributes_SetIssueAdvectionWarnings, METH_VARARGS},
    {"GetIssueAdvectionWarnings", LimitCycleAttributes_GetIssueAdvectionWarnings, METH_VARARGS},
    {"SetIssueBoundaryWarnings", LimitCycleAttributes_SetIssueBoundaryWarnings, METH_VARARGS},
    {"GetIssueBoundaryWarnings", LimitCycleAttributes_GetIssueBoundaryWarnings, METH_VARARGS},
    {"SetIssueTerminationWarnings", LimitCycleAttributes_SetIssueTerminationWarnings, METH_VARARGS},
    {"GetIssueTerminationWarnings", LimitCycleAttributes_GetIssueTerminationWarnings, METH_VARARGS},
    {"SetIssueStepsizeWarnings", LimitCycleAttributes_SetIssueStepsizeWarnings, METH_VARARGS},
    {"GetIssueStepsizeWarnings", LimitCycleAttributes_GetIssueStepsizeWarnings, METH_VARARGS},
    {"SetIssueStiffnessWarnings", LimitCycleAttributes_SetIssueStiffnessWarnings, METH_VARARGS},
    {"GetIssueStiffnessWarnings", LimitCycleAttributes_GetIssueStiffnessWarnings, METH_VARARGS},
    {"SetIssueCriticalPointsWarnings", LimitCycleAttributes_SetIssueCriticalPointsWarnings, METH_VARARGS},
    {"GetIssueCriticalPointsWarnings", LimitCycleAttributes_GetIssueCriticalPointsWarnings, METH_VARARGS},
    {"SetCriticalPointThreshold", LimitCycleAttributes_SetCriticalPointThreshold, METH_VARARGS},
    {"GetCriticalPointThreshold", LimitCycleAttributes_GetCriticalPointThreshold, METH_VARARGS},
    {"SetCorrelationDistanceAngTol", LimitCycleAttributes_SetCorrelationDistanceAngTol, METH_VARARGS},
    {"GetCorrelationDistanceAngTol", LimitCycleAttributes_GetCorrelationDistanceAngTol, METH_VARARGS},
    {"SetCorrelationDistanceMinDistAbsolute", LimitCycleAttributes_SetCorrelationDistanceMinDistAbsolute, METH_VARARGS},
    {"GetCorrelationDistanceMinDistAbsolute", LimitCycleAttributes_GetCorrelationDistanceMinDistAbsolute, METH_VARARGS},
    {"SetCorrelationDistanceMinDistBBox", LimitCycleAttributes_SetCorrelationDistanceMinDistBBox, METH_VARARGS},
    {"GetCorrelationDistanceMinDistBBox", LimitCycleAttributes_GetCorrelationDistanceMinDistBBox, METH_VARARGS},
    {"SetCorrelationDistanceMinDistType", LimitCycleAttributes_SetCorrelationDistanceMinDistType, METH_VARARGS},
    {"GetCorrelationDistanceMinDistType", LimitCycleAttributes_GetCorrelationDistanceMinDistType, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
LimitCycleAttributes_dealloc(PyObject *v)
{
   LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
LimitCycleAttributes_compare(PyObject *v, PyObject *w)
{
    LimitCycleAttributes *a = ((LimitCycleAttributesObject *)v)->data;
    LimitCycleAttributes *b = ((LimitCycleAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyLimitCycleAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "sourceType") == 0)
        return LimitCycleAttributes_GetSourceType(self, NULL);
    if(strcmp(name, "SpecifiedLine") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::SpecifiedLine));
    if(strcmp(name, "SpecifiedPlane") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::SpecifiedPlane));

    if(strcmp(name, "lineStart") == 0)
        return LimitCycleAttributes_GetLineStart(self, NULL);
    if(strcmp(name, "lineEnd") == 0)
        return LimitCycleAttributes_GetLineEnd(self, NULL);
    if(strcmp(name, "planeOrigin") == 0)
        return LimitCycleAttributes_GetPlaneOrigin(self, NULL);
    if(strcmp(name, "planeNormal") == 0)
        return LimitCycleAttributes_GetPlaneNormal(self, NULL);
    if(strcmp(name, "planeUpAxis") == 0)
        return LimitCycleAttributes_GetPlaneUpAxis(self, NULL);
    if(strcmp(name, "sampleDensity0") == 0)
        return LimitCycleAttributes_GetSampleDensity0(self, NULL);
    if(strcmp(name, "sampleDensity1") == 0)
        return LimitCycleAttributes_GetSampleDensity1(self, NULL);
    if(strcmp(name, "dataValue") == 0)
        return LimitCycleAttributes_GetDataValue(self, NULL);
    if(strcmp(name, "Solid") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::Solid));
    if(strcmp(name, "SeedPointID") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::SeedPointID));
    if(strcmp(name, "Speed") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::Speed));
    if(strcmp(name, "Vorticity") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::Vorticity));
    if(strcmp(name, "ArcLength") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::ArcLength));
    if(strcmp(name, "TimeAbsolute") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::TimeAbsolute));
    if(strcmp(name, "TimeRelative") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::TimeRelative));
    if(strcmp(name, "AverageDistanceFromSeed") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::AverageDistanceFromSeed));
    if(strcmp(name, "CorrelationDistance") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::CorrelationDistance));
    if(strcmp(name, "Difference") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::Difference));
    if(strcmp(name, "Variable") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::Variable));

    if(strcmp(name, "dataVariable") == 0)
        return LimitCycleAttributes_GetDataVariable(self, NULL);
    if(strcmp(name, "integrationDirection") == 0)
        return LimitCycleAttributes_GetIntegrationDirection(self, NULL);
    if(strcmp(name, "Forward") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::Forward));
    if(strcmp(name, "Backward") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::Backward));
    if(strcmp(name, "Both") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::Both));
    if(strcmp(name, "ForwardDirectionless") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::ForwardDirectionless));
    if(strcmp(name, "BackwardDirectionless") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::BackwardDirectionless));
    if(strcmp(name, "BothDirectionless") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::BothDirectionless));

    if(strcmp(name, "maxSteps") == 0)
        return LimitCycleAttributes_GetMaxSteps(self, NULL);
    if(strcmp(name, "terminateByDistance") == 0)
        return LimitCycleAttributes_GetTerminateByDistance(self, NULL);
    if(strcmp(name, "termDistance") == 0)
        return LimitCycleAttributes_GetTermDistance(self, NULL);
    if(strcmp(name, "terminateByTime") == 0)
        return LimitCycleAttributes_GetTerminateByTime(self, NULL);
    if(strcmp(name, "termTime") == 0)
        return LimitCycleAttributes_GetTermTime(self, NULL);
    if(strcmp(name, "maxStepLength") == 0)
        return LimitCycleAttributes_GetMaxStepLength(self, NULL);
    if(strcmp(name, "limitMaximumTimestep") == 0)
        return LimitCycleAttributes_GetLimitMaximumTimestep(self, NULL);
    if(strcmp(name, "maxTimeStep") == 0)
        return LimitCycleAttributes_GetMaxTimeStep(self, NULL);
    if(strcmp(name, "relTol") == 0)
        return LimitCycleAttributes_GetRelTol(self, NULL);
    if(strcmp(name, "absTolSizeType") == 0)
        return LimitCycleAttributes_GetAbsTolSizeType(self, NULL);
    if(strcmp(name, "Absolute") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::Absolute));
    if(strcmp(name, "FractionOfBBox") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::FractionOfBBox));

    if(strcmp(name, "absTolAbsolute") == 0)
        return LimitCycleAttributes_GetAbsTolAbsolute(self, NULL);
    if(strcmp(name, "absTolBBox") == 0)
        return LimitCycleAttributes_GetAbsTolBBox(self, NULL);
    if(strcmp(name, "fieldType") == 0)
        return LimitCycleAttributes_GetFieldType(self, NULL);
    if(strcmp(name, "Default") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::Default));
    if(strcmp(name, "FlashField") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::FlashField));
    if(strcmp(name, "M3DC12DField") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::M3DC12DField));
    if(strcmp(name, "M3DC13DField") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::M3DC13DField));
    if(strcmp(name, "Nek5000Field") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::Nek5000Field));
    if(strcmp(name, "NektarPPField") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::NektarPPField));
    if(strcmp(name, "NIMRODField") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::NIMRODField));

    if(strcmp(name, "fieldConstant") == 0)
        return LimitCycleAttributes_GetFieldConstant(self, NULL);
    if(strcmp(name, "velocitySource") == 0)
        return LimitCycleAttributes_GetVelocitySource(self, NULL);
    if(strcmp(name, "integrationType") == 0)
        return LimitCycleAttributes_GetIntegrationType(self, NULL);
    if(strcmp(name, "Euler") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::Euler));
    if(strcmp(name, "Leapfrog") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::Leapfrog));
    if(strcmp(name, "DormandPrince") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::DormandPrince));
    if(strcmp(name, "AdamsBashforth") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::AdamsBashforth));
    if(strcmp(name, "RK4") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::RK4));
    if(strcmp(name, "M3DC12DIntegrator") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::M3DC12DIntegrator));

    if(strcmp(name, "parallelizationAlgorithmType") == 0)
        return LimitCycleAttributes_GetParallelizationAlgorithmType(self, NULL);
    if(strcmp(name, "LoadOnDemand") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::LoadOnDemand));
    if(strcmp(name, "ParallelStaticDomains") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::ParallelStaticDomains));
    if(strcmp(name, "MasterSlave") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::MasterSlave));
    if(strcmp(name, "VisItSelects") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::VisItSelects));

    if(strcmp(name, "maxProcessCount") == 0)
        return LimitCycleAttributes_GetMaxProcessCount(self, NULL);
    if(strcmp(name, "maxDomainCacheSize") == 0)
        return LimitCycleAttributes_GetMaxDomainCacheSize(self, NULL);
    if(strcmp(name, "workGroupSize") == 0)
        return LimitCycleAttributes_GetWorkGroupSize(self, NULL);
    if(strcmp(name, "pathlines") == 0)
        return LimitCycleAttributes_GetPathlines(self, NULL);
    if(strcmp(name, "pathlinesOverrideStartingTimeFlag") == 0)
        return LimitCycleAttributes_GetPathlinesOverrideStartingTimeFlag(self, NULL);
    if(strcmp(name, "pathlinesOverrideStartingTime") == 0)
        return LimitCycleAttributes_GetPathlinesOverrideStartingTime(self, NULL);
    if(strcmp(name, "pathlinesPeriod") == 0)
        return LimitCycleAttributes_GetPathlinesPeriod(self, NULL);
    if(strcmp(name, "pathlinesCMFE") == 0)
        return LimitCycleAttributes_GetPathlinesCMFE(self, NULL);
    if(strcmp(name, "CONN_CMFE") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::CONN_CMFE));
    if(strcmp(name, "POS_CMFE") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::POS_CMFE));

    if(strcmp(name, "sampleDistance0") == 0)
        return LimitCycleAttributes_GetSampleDistance0(self, NULL);
    if(strcmp(name, "sampleDistance1") == 0)
        return LimitCycleAttributes_GetSampleDistance1(self, NULL);
    if(strcmp(name, "sampleDistance2") == 0)
        return LimitCycleAttributes_GetSampleDistance2(self, NULL);
    if(strcmp(name, "fillInterior") == 0)
        return LimitCycleAttributes_GetFillInterior(self, NULL);
    if(strcmp(name, "randomSamples") == 0)
        return LimitCycleAttributes_GetRandomSamples(self, NULL);
    if(strcmp(name, "randomSeed") == 0)
        return LimitCycleAttributes_GetRandomSeed(self, NULL);
    if(strcmp(name, "numberOfRandomSamples") == 0)
        return LimitCycleAttributes_GetNumberOfRandomSamples(self, NULL);
    if(strcmp(name, "forceNodeCenteredData") == 0)
        return LimitCycleAttributes_GetForceNodeCenteredData(self, NULL);
    if(strcmp(name, "cycleTolerance") == 0)
        return LimitCycleAttributes_GetCycleTolerance(self, NULL);
    if(strcmp(name, "maxIterations") == 0)
        return LimitCycleAttributes_GetMaxIterations(self, NULL);
    if(strcmp(name, "showPartialResults") == 0)
        return LimitCycleAttributes_GetShowPartialResults(self, NULL);
    if(strcmp(name, "showReturnDistances") == 0)
        return LimitCycleAttributes_GetShowReturnDistances(self, NULL);
    if(strcmp(name, "issueAdvectionWarnings") == 0)
        return LimitCycleAttributes_GetIssueAdvectionWarnings(self, NULL);
    if(strcmp(name, "issueBoundaryWarnings") == 0)
        return LimitCycleAttributes_GetIssueBoundaryWarnings(self, NULL);
    if(strcmp(name, "issueTerminationWarnings") == 0)
        return LimitCycleAttributes_GetIssueTerminationWarnings(self, NULL);
    if(strcmp(name, "issueStepsizeWarnings") == 0)
        return LimitCycleAttributes_GetIssueStepsizeWarnings(self, NULL);
    if(strcmp(name, "issueStiffnessWarnings") == 0)
        return LimitCycleAttributes_GetIssueStiffnessWarnings(self, NULL);
    if(strcmp(name, "issueCriticalPointsWarnings") == 0)
        return LimitCycleAttributes_GetIssueCriticalPointsWarnings(self, NULL);
    if(strcmp(name, "criticalPointThreshold") == 0)
        return LimitCycleAttributes_GetCriticalPointThreshold(self, NULL);
    if(strcmp(name, "correlationDistanceAngTol") == 0)
        return LimitCycleAttributes_GetCorrelationDistanceAngTol(self, NULL);
    if(strcmp(name, "correlationDistanceMinDistAbsolute") == 0)
        return LimitCycleAttributes_GetCorrelationDistanceMinDistAbsolute(self, NULL);
    if(strcmp(name, "correlationDistanceMinDistBBox") == 0)
        return LimitCycleAttributes_GetCorrelationDistanceMinDistBBox(self, NULL);
    if(strcmp(name, "correlationDistanceMinDistType") == 0)
        return LimitCycleAttributes_GetCorrelationDistanceMinDistType(self, NULL);
    if(strcmp(name, "Absolute") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::Absolute));
    if(strcmp(name, "FractionOfBBox") == 0)
        return PyInt_FromLong(long(LimitCycleAttributes::FractionOfBBox));


    return Py_FindMethod(PyLimitCycleAttributes_methods, self, name);
}

int
PyLimitCycleAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "sourceType") == 0)
        obj = LimitCycleAttributes_SetSourceType(self, tuple);
    else if(strcmp(name, "lineStart") == 0)
        obj = LimitCycleAttributes_SetLineStart(self, tuple);
    else if(strcmp(name, "lineEnd") == 0)
        obj = LimitCycleAttributes_SetLineEnd(self, tuple);
    else if(strcmp(name, "planeOrigin") == 0)
        obj = LimitCycleAttributes_SetPlaneOrigin(self, tuple);
    else if(strcmp(name, "planeNormal") == 0)
        obj = LimitCycleAttributes_SetPlaneNormal(self, tuple);
    else if(strcmp(name, "planeUpAxis") == 0)
        obj = LimitCycleAttributes_SetPlaneUpAxis(self, tuple);
    else if(strcmp(name, "sampleDensity0") == 0)
        obj = LimitCycleAttributes_SetSampleDensity0(self, tuple);
    else if(strcmp(name, "sampleDensity1") == 0)
        obj = LimitCycleAttributes_SetSampleDensity1(self, tuple);
    else if(strcmp(name, "dataValue") == 0)
        obj = LimitCycleAttributes_SetDataValue(self, tuple);
    else if(strcmp(name, "dataVariable") == 0)
        obj = LimitCycleAttributes_SetDataVariable(self, tuple);
    else if(strcmp(name, "integrationDirection") == 0)
        obj = LimitCycleAttributes_SetIntegrationDirection(self, tuple);
    else if(strcmp(name, "maxSteps") == 0)
        obj = LimitCycleAttributes_SetMaxSteps(self, tuple);
    else if(strcmp(name, "terminateByDistance") == 0)
        obj = LimitCycleAttributes_SetTerminateByDistance(self, tuple);
    else if(strcmp(name, "termDistance") == 0)
        obj = LimitCycleAttributes_SetTermDistance(self, tuple);
    else if(strcmp(name, "terminateByTime") == 0)
        obj = LimitCycleAttributes_SetTerminateByTime(self, tuple);
    else if(strcmp(name, "termTime") == 0)
        obj = LimitCycleAttributes_SetTermTime(self, tuple);
    else if(strcmp(name, "maxStepLength") == 0)
        obj = LimitCycleAttributes_SetMaxStepLength(self, tuple);
    else if(strcmp(name, "limitMaximumTimestep") == 0)
        obj = LimitCycleAttributes_SetLimitMaximumTimestep(self, tuple);
    else if(strcmp(name, "maxTimeStep") == 0)
        obj = LimitCycleAttributes_SetMaxTimeStep(self, tuple);
    else if(strcmp(name, "relTol") == 0)
        obj = LimitCycleAttributes_SetRelTol(self, tuple);
    else if(strcmp(name, "absTolSizeType") == 0)
        obj = LimitCycleAttributes_SetAbsTolSizeType(self, tuple);
    else if(strcmp(name, "absTolAbsolute") == 0)
        obj = LimitCycleAttributes_SetAbsTolAbsolute(self, tuple);
    else if(strcmp(name, "absTolBBox") == 0)
        obj = LimitCycleAttributes_SetAbsTolBBox(self, tuple);
    else if(strcmp(name, "fieldType") == 0)
        obj = LimitCycleAttributes_SetFieldType(self, tuple);
    else if(strcmp(name, "fieldConstant") == 0)
        obj = LimitCycleAttributes_SetFieldConstant(self, tuple);
    else if(strcmp(name, "velocitySource") == 0)
        obj = LimitCycleAttributes_SetVelocitySource(self, tuple);
    else if(strcmp(name, "integrationType") == 0)
        obj = LimitCycleAttributes_SetIntegrationType(self, tuple);
    else if(strcmp(name, "parallelizationAlgorithmType") == 0)
        obj = LimitCycleAttributes_SetParallelizationAlgorithmType(self, tuple);
    else if(strcmp(name, "maxProcessCount") == 0)
        obj = LimitCycleAttributes_SetMaxProcessCount(self, tuple);
    else if(strcmp(name, "maxDomainCacheSize") == 0)
        obj = LimitCycleAttributes_SetMaxDomainCacheSize(self, tuple);
    else if(strcmp(name, "workGroupSize") == 0)
        obj = LimitCycleAttributes_SetWorkGroupSize(self, tuple);
    else if(strcmp(name, "pathlines") == 0)
        obj = LimitCycleAttributes_SetPathlines(self, tuple);
    else if(strcmp(name, "pathlinesOverrideStartingTimeFlag") == 0)
        obj = LimitCycleAttributes_SetPathlinesOverrideStartingTimeFlag(self, tuple);
    else if(strcmp(name, "pathlinesOverrideStartingTime") == 0)
        obj = LimitCycleAttributes_SetPathlinesOverrideStartingTime(self, tuple);
    else if(strcmp(name, "pathlinesPeriod") == 0)
        obj = LimitCycleAttributes_SetPathlinesPeriod(self, tuple);
    else if(strcmp(name, "pathlinesCMFE") == 0)
        obj = LimitCycleAttributes_SetPathlinesCMFE(self, tuple);
    else if(strcmp(name, "sampleDistance0") == 0)
        obj = LimitCycleAttributes_SetSampleDistance0(self, tuple);
    else if(strcmp(name, "sampleDistance1") == 0)
        obj = LimitCycleAttributes_SetSampleDistance1(self, tuple);
    else if(strcmp(name, "sampleDistance2") == 0)
        obj = LimitCycleAttributes_SetSampleDistance2(self, tuple);
    else if(strcmp(name, "fillInterior") == 0)
        obj = LimitCycleAttributes_SetFillInterior(self, tuple);
    else if(strcmp(name, "randomSamples") == 0)
        obj = LimitCycleAttributes_SetRandomSamples(self, tuple);
    else if(strcmp(name, "randomSeed") == 0)
        obj = LimitCycleAttributes_SetRandomSeed(self, tuple);
    else if(strcmp(name, "numberOfRandomSamples") == 0)
        obj = LimitCycleAttributes_SetNumberOfRandomSamples(self, tuple);
    else if(strcmp(name, "forceNodeCenteredData") == 0)
        obj = LimitCycleAttributes_SetForceNodeCenteredData(self, tuple);
    else if(strcmp(name, "cycleTolerance") == 0)
        obj = LimitCycleAttributes_SetCycleTolerance(self, tuple);
    else if(strcmp(name, "maxIterations") == 0)
        obj = LimitCycleAttributes_SetMaxIterations(self, tuple);
    else if(strcmp(name, "showPartialResults") == 0)
        obj = LimitCycleAttributes_SetShowPartialResults(self, tuple);
    else if(strcmp(name, "showReturnDistances") == 0)
        obj = LimitCycleAttributes_SetShowReturnDistances(self, tuple);
    else if(strcmp(name, "issueAdvectionWarnings") == 0)
        obj = LimitCycleAttributes_SetIssueAdvectionWarnings(self, tuple);
    else if(strcmp(name, "issueBoundaryWarnings") == 0)
        obj = LimitCycleAttributes_SetIssueBoundaryWarnings(self, tuple);
    else if(strcmp(name, "issueTerminationWarnings") == 0)
        obj = LimitCycleAttributes_SetIssueTerminationWarnings(self, tuple);
    else if(strcmp(name, "issueStepsizeWarnings") == 0)
        obj = LimitCycleAttributes_SetIssueStepsizeWarnings(self, tuple);
    else if(strcmp(name, "issueStiffnessWarnings") == 0)
        obj = LimitCycleAttributes_SetIssueStiffnessWarnings(self, tuple);
    else if(strcmp(name, "issueCriticalPointsWarnings") == 0)
        obj = LimitCycleAttributes_SetIssueCriticalPointsWarnings(self, tuple);
    else if(strcmp(name, "criticalPointThreshold") == 0)
        obj = LimitCycleAttributes_SetCriticalPointThreshold(self, tuple);
    else if(strcmp(name, "correlationDistanceAngTol") == 0)
        obj = LimitCycleAttributes_SetCorrelationDistanceAngTol(self, tuple);
    else if(strcmp(name, "correlationDistanceMinDistAbsolute") == 0)
        obj = LimitCycleAttributes_SetCorrelationDistanceMinDistAbsolute(self, tuple);
    else if(strcmp(name, "correlationDistanceMinDistBBox") == 0)
        obj = LimitCycleAttributes_SetCorrelationDistanceMinDistBBox(self, tuple);
    else if(strcmp(name, "correlationDistanceMinDistType") == 0)
        obj = LimitCycleAttributes_SetCorrelationDistanceMinDistType(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
LimitCycleAttributes_print(PyObject *v, FILE *fp, int flags)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)v;
    fprintf(fp, "%s", PyLimitCycleAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
LimitCycleAttributes_str(PyObject *v)
{
    LimitCycleAttributesObject *obj = (LimitCycleAttributesObject *)v;
    return PyString_FromString(PyLimitCycleAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *LimitCycleAttributes_Purpose = "Attributes for the LimitCycle";
#else
static char *LimitCycleAttributes_Purpose = "Attributes for the LimitCycle";
#endif

//
// The type description structure
//
static PyTypeObject LimitCycleAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "LimitCycleAttributes",                    // tp_name
    sizeof(LimitCycleAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)LimitCycleAttributes_dealloc,  // tp_dealloc
    (printfunc)LimitCycleAttributes_print,     // tp_print
    (getattrfunc)PyLimitCycleAttributes_getattr, // tp_getattr
    (setattrfunc)PyLimitCycleAttributes_setattr, // tp_setattr
    (cmpfunc)LimitCycleAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)LimitCycleAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    LimitCycleAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static LimitCycleAttributes *defaultAtts = 0;
static LimitCycleAttributes *currentAtts = 0;

static PyObject *
NewLimitCycleAttributes(int useCurrent)
{
    LimitCycleAttributesObject *newObject;
    newObject = PyObject_NEW(LimitCycleAttributesObject, &LimitCycleAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new LimitCycleAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new LimitCycleAttributes(*defaultAtts);
    else
        newObject->data = new LimitCycleAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapLimitCycleAttributes(const LimitCycleAttributes *attr)
{
    LimitCycleAttributesObject *newObject;
    newObject = PyObject_NEW(LimitCycleAttributesObject, &LimitCycleAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (LimitCycleAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
LimitCycleAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewLimitCycleAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef LimitCycleAttributesMethods[] = {
    {"LimitCycleAttributes", LimitCycleAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *LimitCycleAttributesObserver = 0;

std::string
PyLimitCycleAttributes_GetLogString()
{
    std::string s("LimitCycleAtts = LimitCycleAttributes()\n");
    if(currentAtts != 0)
        s += PyLimitCycleAttributes_ToString(currentAtts, "LimitCycleAtts.");
    return s;
}

static void
PyLimitCycleAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("LimitCycleAtts = LimitCycleAttributes()\n");
        s += PyLimitCycleAttributes_ToString(currentAtts, "LimitCycleAtts.");
        cb(s);
    }
}

void
PyLimitCycleAttributes_StartUp(LimitCycleAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyLimitCycleAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(LimitCycleAttributesObserver == 0)
    {
        LimitCycleAttributesObserver = new ObserverToCallback(subj,
            PyLimitCycleAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyLimitCycleAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete LimitCycleAttributesObserver;
    LimitCycleAttributesObserver = 0;
}

PyMethodDef *
PyLimitCycleAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return LimitCycleAttributesMethods;
}

bool
PyLimitCycleAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &LimitCycleAttributesType);
}

LimitCycleAttributes *
PyLimitCycleAttributes_FromPyObject(PyObject *obj)
{
    LimitCycleAttributesObject *obj2 = (LimitCycleAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyLimitCycleAttributes_New()
{
    return NewLimitCycleAttributes(0);
}

PyObject *
PyLimitCycleAttributes_Wrap(const LimitCycleAttributes *attr)
{
    return WrapLimitCycleAttributes(attr);
}

void
PyLimitCycleAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    LimitCycleAttributesObject *obj2 = (LimitCycleAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyLimitCycleAttributes_SetDefaults(const LimitCycleAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new LimitCycleAttributes(*atts);
}

