// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: LimitCyclePluginInfo.C
// ****************************************************************************

#include <LimitCyclePluginInfo.h>
#include <LimitCycleAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(LimitCycle,OP_EXPORT)

VISIT_OPERATOR_PLUGIN_ENTRY(LimitCycle,General)

// ****************************************************************************
//  Method: LimitCycleGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the operator plugin.
//
//  Returns:    A pointer to the name of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
LimitCycleGeneralPluginInfo::GetName() const
{
    return "LimitCycle";
}

// ****************************************************************************
//  Method: LimitCycleGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the operator plugin.
//
//  Returns:    A pointer to the version of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
LimitCycleGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: LimitCycleGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the operator plugin.
//
//  Returns:    A pointer to the id of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
LimitCycleGeneralPluginInfo::GetID() const
{
    return "LimitCycle_1.0";
}
// ****************************************************************************
//  Method: LimitCycleGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
LimitCycleGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}

// ****************************************************************************
//  Method: LimitCycleGeneralPluginInfo::GetCategoryName
//
//  Purpose:
//    Return the category name to which the operator belongs.
//
//  Returns:    Return the category name to which the operator belongs.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
LimitCycleGeneralPluginInfo::GetCategoryName() const
{
    return "Integral Curves";
}
