// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISLAGRANGIANWINDOW_H
#define QVISLAGRANGIANWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>

class LagrangianAttributes;
class QLabel;
class QLineEdit;
class QButtonGroup;
class QvisVariableButton;

// ****************************************************************************
// Class: QvisLagrangianWindow
//
// Purpose:
//    Defines QvisLagrangianWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

class QvisLagrangianWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisLagrangianWindow(const int type,
                         LagrangianAttributes *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisLagrangianWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
  private slots:
    void seedPointProcessText();
    void numStepsProcessText();
    void XAxisSampleChanged(int val);
    void YAxisSampleChanged(int val);
    void variableChanged(const QString &varName);
  private:
    QLineEdit *seedPoint;
    QLineEdit *numSteps;
    QWidget      *XAxisSample;
    QButtonGroup *XAxisSampleButtonGroup;
    QWidget      *YAxisSample;
    QButtonGroup *YAxisSampleButtonGroup;
    QvisVariableButton *variable;
    QLabel *seedPointLabel;
    QLabel *numStepsLabel;
    QLabel *XAxisSampleLabel;
    QLabel *YAxisSampleLabel;
    QLabel *variableLabel;

    LagrangianAttributes *atts;
};



#endif
