// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  LagrangianScriptingPluginInfo.C
// ************************************************************************* //
#include <PyLagrangianAttributes.h>
#include <LagrangianPluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(Lagrangian,Scripting)

// ****************************************************************************
// Method: LagrangianScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
LagrangianScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyLagrangianAttributes_StartUp((LagrangianAttributes *)subj, data);
}

// ****************************************************************************
// Method: LagrangianScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
LagrangianScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyLagrangianAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: LagrangianScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is Lagrangian plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
LagrangianScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyLagrangianAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: LagrangianScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
LagrangianScriptingPluginInfo::GetLogString()
{
    std::string s(PyLagrangianAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: LagrangianScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
LagrangianScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyLagrangianAttributes_SetDefaults((const LagrangianAttributes *)atts);
}
