// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: LagrangianPluginInfo.h
// ****************************************************************************

#ifndef LAGRANGIAN_PLUGIN_INFO_H
#define LAGRANGIAN_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class LagrangianAttributes;

// ****************************************************************************
//  Class: LagrangianPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an Lagrangian operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class LagrangianGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class LagrangianCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual LagrangianGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
    virtual ExpressionList *GetCreatedExpressions(const avtDatabaseMetaData *) const;
};

class LagrangianGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual LagrangianCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
};

class LagrangianViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual LagrangianCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static LagrangianAttributes *defaultAtts;
    static LagrangianAttributes *clientAtts;
};

class LagrangianViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual LagrangianViewerEnginePluginInfo
{
  public:
};

class LagrangianEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual LagrangianViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class LagrangianScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual LagrangianCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
