// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef LAGRANGIANATTRIBUTES_H
#define LAGRANGIANATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: LagrangianAttributes
//
// Purpose:
//    Attributes for Lagrangian operator
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class LagrangianAttributes : public AttributeSubject
{
public:
    enum sampleType
    {
        Step,
        Time,
        ArcLength,
        Speed,
        Vorticity,
        Variable
    };

    // These constructors are for objects of this class
    LagrangianAttributes();
    LagrangianAttributes(const LagrangianAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    LagrangianAttributes(private_tmfs_t tmfs);
    LagrangianAttributes(const LagrangianAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~LagrangianAttributes();

    virtual LagrangianAttributes& operator = (const LagrangianAttributes &obj);
    virtual bool operator == (const LagrangianAttributes &obj) const;
    virtual bool operator != (const LagrangianAttributes &obj) const;
private:
    void Init();
    void Copy(const LagrangianAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectSeedPoint();
    void SelectVariable();

    // Property setting methods
    void SetSeedPoint(const double *seedPoint_);
    void SetNumSteps(int numSteps_);
    void SetXAxisSample(sampleType XAxisSample_);
    void SetYAxisSample(sampleType YAxisSample_);
    void SetVariable(const std::string &variable_);

    // Property getting methods
    const double      *GetSeedPoint() const;
          double      *GetSeedPoint();
    int               GetNumSteps() const;
    sampleType        GetXAxisSample() const;
    sampleType        GetYAxisSample() const;
    const std::string &GetVariable() const;
          std::string &GetVariable();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string sampleType_ToString(sampleType);
    static bool sampleType_FromString(const std::string &, sampleType &);
protected:
    static std::string sampleType_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_seedPoint = 0,
        ID_numSteps,
        ID_XAxisSample,
        ID_YAxisSample,
        ID_variable,
        ID__LAST
    };

private:
    double      seedPoint[3];
    int         numSteps;
    int         XAxisSample;
    int         YAxisSample;
    std::string variable;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define LAGRANGIANATTRIBUTES_TMFS "Diiis"

#endif
