// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: LCSViewerEnginePluginInfo.C
// ****************************************************************************

#include <LCSPluginInfo.h>
#include <LCSAttributes.h>

//
// Storage for static data elements.
//
LCSAttributes *LCSViewerEnginePluginInfo::clientAtts = NULL;
LCSAttributes *LCSViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  LCSViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
LCSViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (LCSViewerEnginePluginInfo::clientAtts == NULL)
    {
        LCSViewerEnginePluginInfo::clientAtts  = new LCSAttributes;
        LCSViewerEnginePluginInfo::defaultAtts = new LCSAttributes;
    }
}

// ****************************************************************************
//  Method: LCSViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
LCSViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: LCSViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
LCSViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: LCSViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
LCSViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(LCSAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: LCSViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
LCSViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(LCSAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: LCSViewerEnginePluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts        The attribute subject to initialize.
//    plot        The viewer plot that owns the operator.
//    fromDefault True to initialize the attributes from the defaults. False
//                to initialize from the current attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
LCSViewerEnginePluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const avtPlotMetaData &plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(LCSAttributes*)atts = *defaultAtts;
    else
        *(LCSAttributes*)atts = *clientAtts;

    UpdateOperatorAtts(atts, plot);
}

// ****************************************************************************
//  Method: LCSViewerEnginePluginInfo::UpdateOperatorAtts
//
//  Purpose:
//    Update the operator attributes when using operator expressions.
//
//  Arguments:
//    atts        The attribute subject to update.
//    plot        The viewer plot that owns the operator.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
LCSViewerEnginePluginInfo::UpdateOperatorAtts(AttributeSubject *atts, const avtPlotMetaData &plot)
{
}

// ****************************************************************************
//  Method: LCSViewerEnginePluginInfo::GetOperatorVarDescription
//
//  Purpose:
//    Return the operator variable description.
//
//  Arguments:
//    atts        The attribute subject to initialize.
//    plot        The viewer plot that owns the operator.
//
//  Programmer: Allen Sanderson
//  Creation:   19 August 2013
//
// ****************************************************************************

#include <avtPlotMetaData.h>
#include <cstring>

std::string
LCSViewerEnginePluginInfo::GetOperatorVarDescription(AttributeSubject *atts,
                                                     const avtPlotMetaData &plot)
{
    LCSAttributes *atts_in = (LCSAttributes *)atts;

    const char *typeString[3][7] =
    { { "Time", "Arc length", "Ave. dist. from seed", "", "", "", "" },
      { "Smallest", "Intermediate", "Largest",
        "Pos. shear", "Neg. shear",
        "Pos. linear shear", "Pos. combo shear" },
      { "FTLE", "FDLE", "FSLE", "", "", "", "" } };

    const char *operatorString[4] = { "Base", "Gradient", "Jacobian", "Ratio" };

    std::string var = plot.GetVariableName();

    if( strncmp(var.c_str(), "operators/LCS/",
                strlen("operators/LCS/")) == 0)
    {
      std::string justTheVar = var.substr(strlen("operators/LCS/"));

      var = justTheVar;
    }

    int i, j, k;

    if( atts_in->GetOperationType() == LCSAttributes::IntegrationTime ||
        atts_in->GetOperationType() == LCSAttributes::ArcLength ||
        atts_in->GetOperationType() == LCSAttributes::AverageDistanceFromSeed )
    {
        i = 0;
        j = atts_in->GetOperationType();
        k = atts_in->GetOperatorType();

        var += std::string(" - ") + std::string(typeString[i][j]) +
               std::string(" ")   + std::string(operatorString[k]);

    }
    else if( atts_in->GetOperationType() == LCSAttributes::EigenValue ||
             atts_in->GetOperationType() == LCSAttributes::EigenVector )
    {
        i = 1;
        j = atts_in->GetEigenComponent();

        var += std::string(" - ") + std::string(typeString[i][j]) +
          std::string(" Eigen ");

        if( atts_in->GetOperationType() == LCSAttributes::EigenValue )
          var += std::string( "value" );
        else if( atts_in->GetOperationType() == LCSAttributes::EigenVector )
          var += std::string( "vector" );
    }
    else //if( atts_in->GetOperationType() == LCSAttributes::Lyapunov )
    {
        i = 1;
        j = atts_in->GetEigenComponent();
        var += std::string(" - ") + std::string(typeString[i][j]);

        i = 2;
        j = atts_in->GetTerminationType();
        var += std::string(" ")   + std::string(typeString[i][j]);
    }

    return var;
}

// ****************************************************************************
//  Method: LCSViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
LCSViewerEnginePluginInfo::GetMenuName() const
{
    return "LCS";
}

