// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef LCSATTRIBUTES_H
#define LCSATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: LCSAttributes
//
// Purpose:
//    Attributes for LCS
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class LCSAttributes : public AttributeSubject
{
public:
    enum SourceType
    {
        NativeMesh,
        RegularGrid
    };
    enum Extents
    {
        Full,
        Subset
    };
    enum AuxiliaryGrid
    {
        None,
        TwoDim,
        ThreeDim
    };
    enum IntegrationDirection
    {
        Forward,
        Backward,
        Both
    };
    enum FieldType
    {
        Default,
        FlashField,
        M3DC12DField,
        M3DC13DField,
        Nek5000Field,
        NektarPPField,
        NIMRODField
    };
    enum IntegrationType
    {
        Euler,
        Leapfrog,
        DormandPrince,
        AdamsBashforth,
        RK4,
        M3DC12DIntegrator
    };
    enum SizeType
    {
        Absolute,
        FractionOfBBox
    };
    enum ParallelizationAlgorithmType
    {
        LoadOnDemand,
        ParallelStaticDomains,
        MasterSlave,
        VisItSelects
    };
    enum OperationType
    {
        IntegrationTime,
        ArcLength,
        AverageDistanceFromSeed,
        EigenValue,
        EigenVector,
        Lyapunov
    };
    enum CauchyGreenTensor
    {
        Left,
        Right
    };
    enum EigenComponent
    {
        Smallest,
        Intermediate,
        Largest,
        PosShearVector,
        NegShearVector,
        PosLambdaShearVector,
        NegLambdaShearVector
    };
    enum OperatorType
    {
        BaseValue,
        Gradient
    };
    enum TerminationType
    {
        Time,
        Distance,
        Size
    };
    enum PathlinesCMFE
    {
        CONN_CMFE,
        POS_CMFE
    };

    // These constructors are for objects of this class
    LCSAttributes();
    LCSAttributes(const LCSAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    LCSAttributes(private_tmfs_t tmfs);
    LCSAttributes(const LCSAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~LCSAttributes();

    virtual LCSAttributes& operator = (const LCSAttributes &obj);
    virtual bool operator == (const LCSAttributes &obj) const;
    virtual bool operator != (const LCSAttributes &obj) const;
private:
    void Init();
    void Copy(const LCSAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectResolution();
    void SelectStartPosition();
    void SelectEndPosition();
    void SelectVelocitySource();

    // Property setting methods
    void SetSourceType(SourceType sourceType_);
    void SetResolution(const int *Resolution_);
    void SetUseDataSetStart(Extents UseDataSetStart_);
    void SetStartPosition(const double *StartPosition_);
    void SetUseDataSetEnd(Extents UseDataSetEnd_);
    void SetEndPosition(const double *EndPosition_);
    void SetIntegrationDirection(IntegrationDirection integrationDirection_);
    void SetAuxiliaryGrid(AuxiliaryGrid auxiliaryGrid_);
    void SetAuxiliaryGridSpacing(double auxiliaryGridSpacing_);
    void SetMaxSteps(int maxSteps_);
    void SetOperationType(OperationType operationType_);
    void SetCauchyGreenTensor(CauchyGreenTensor cauchyGreenTensor_);
    void SetEigenComponent(EigenComponent eigenComponent_);
    void SetEigenWeight(double eigenWeight_);
    void SetOperatorType(OperatorType operatorType_);
    void SetTerminationType(TerminationType terminationType_);
    void SetTerminateBySize(bool terminateBySize_);
    void SetTermSize(double termSize_);
    void SetTerminateByDistance(bool terminateByDistance_);
    void SetTermDistance(double termDistance_);
    void SetTerminateByTime(bool terminateByTime_);
    void SetTermTime(double termTime_);
    void SetMaxStepLength(double maxStepLength_);
    void SetLimitMaximumTimestep(bool limitMaximumTimestep_);
    void SetMaxTimeStep(double maxTimeStep_);
    void SetRelTol(double relTol_);
    void SetAbsTolSizeType(SizeType absTolSizeType_);
    void SetAbsTolAbsolute(double absTolAbsolute_);
    void SetAbsTolBBox(double absTolBBox_);
    void SetFieldType(FieldType fieldType_);
    void SetFieldConstant(double fieldConstant_);
    void SetVelocitySource(const double *velocitySource_);
    void SetIntegrationType(IntegrationType integrationType_);
    void SetClampLogValues(bool clampLogValues_);
    void SetParallelizationAlgorithmType(ParallelizationAlgorithmType parallelizationAlgorithmType_);
    void SetMaxProcessCount(int maxProcessCount_);
    void SetMaxDomainCacheSize(int maxDomainCacheSize_);
    void SetWorkGroupSize(int workGroupSize_);
    void SetPathlines(bool pathlines_);
    void SetPathlinesOverrideStartingTimeFlag(bool pathlinesOverrideStartingTimeFlag_);
    void SetPathlinesOverrideStartingTime(double pathlinesOverrideStartingTime_);
    void SetPathlinesPeriod(double pathlinesPeriod_);
    void SetPathlinesCMFE(PathlinesCMFE pathlinesCMFE_);
    void SetThresholdLimit(double thresholdLimit_);
    void SetRadialLimit(double radialLimit_);
    void SetBoundaryLimit(double boundaryLimit_);
    void SetSeedLimit(int seedLimit_);
    void SetIssueAdvectionWarnings(bool issueAdvectionWarnings_);
    void SetIssueBoundaryWarnings(bool issueBoundaryWarnings_);
    void SetIssueTerminationWarnings(bool issueTerminationWarnings_);
    void SetIssueStepsizeWarnings(bool issueStepsizeWarnings_);
    void SetIssueStiffnessWarnings(bool issueStiffnessWarnings_);
    void SetIssueCriticalPointsWarnings(bool issueCriticalPointsWarnings_);
    void SetCriticalPointThreshold(double criticalPointThreshold_);

    // Property getting methods
    SourceType   GetSourceType() const;
    const int    *GetResolution() const;
          int    *GetResolution();
    Extents      GetUseDataSetStart() const;
    const double *GetStartPosition() const;
          double *GetStartPosition();
    Extents      GetUseDataSetEnd() const;
    const double *GetEndPosition() const;
          double *GetEndPosition();
    IntegrationDirection GetIntegrationDirection() const;
    AuxiliaryGrid GetAuxiliaryGrid() const;
    double       GetAuxiliaryGridSpacing() const;
    int          GetMaxSteps() const;
    OperationType GetOperationType() const;
    CauchyGreenTensor GetCauchyGreenTensor() const;
    EigenComponent GetEigenComponent() const;
    double       GetEigenWeight() const;
    OperatorType GetOperatorType() const;
    TerminationType GetTerminationType() const;
    bool         GetTerminateBySize() const;
    double       GetTermSize() const;
    bool         GetTerminateByDistance() const;
    double       GetTermDistance() const;
    bool         GetTerminateByTime() const;
    double       GetTermTime() const;
    double       GetMaxStepLength() const;
    bool         GetLimitMaximumTimestep() const;
    double       GetMaxTimeStep() const;
    double       GetRelTol() const;
    SizeType     GetAbsTolSizeType() const;
    double       GetAbsTolAbsolute() const;
    double       GetAbsTolBBox() const;
    FieldType    GetFieldType() const;
    double       GetFieldConstant() const;
    const double *GetVelocitySource() const;
          double *GetVelocitySource();
    IntegrationType GetIntegrationType() const;
    bool         GetClampLogValues() const;
    ParallelizationAlgorithmType GetParallelizationAlgorithmType() const;
    int          GetMaxProcessCount() const;
    int          GetMaxDomainCacheSize() const;
    int          GetWorkGroupSize() const;
    bool         GetPathlines() const;
    bool         GetPathlinesOverrideStartingTimeFlag() const;
    double       GetPathlinesOverrideStartingTime() const;
    double       GetPathlinesPeriod() const;
    PathlinesCMFE GetPathlinesCMFE() const;
    double       GetThresholdLimit() const;
    double       GetRadialLimit() const;
    double       GetBoundaryLimit() const;
    int          GetSeedLimit() const;
    bool         GetIssueAdvectionWarnings() const;
    bool         GetIssueBoundaryWarnings() const;
    bool         GetIssueTerminationWarnings() const;
    bool         GetIssueStepsizeWarnings() const;
    bool         GetIssueStiffnessWarnings() const;
    bool         GetIssueCriticalPointsWarnings() const;
    double       GetCriticalPointThreshold() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string SourceType_ToString(SourceType);
    static bool SourceType_FromString(const std::string &, SourceType &);
protected:
    static std::string SourceType_ToString(int);
public:
    static std::string Extents_ToString(Extents);
    static bool Extents_FromString(const std::string &, Extents &);
protected:
    static std::string Extents_ToString(int);
public:
    static std::string AuxiliaryGrid_ToString(AuxiliaryGrid);
    static bool AuxiliaryGrid_FromString(const std::string &, AuxiliaryGrid &);
protected:
    static std::string AuxiliaryGrid_ToString(int);
public:
    static std::string IntegrationDirection_ToString(IntegrationDirection);
    static bool IntegrationDirection_FromString(const std::string &, IntegrationDirection &);
protected:
    static std::string IntegrationDirection_ToString(int);
public:
    static std::string FieldType_ToString(FieldType);
    static bool FieldType_FromString(const std::string &, FieldType &);
protected:
    static std::string FieldType_ToString(int);
public:
    static std::string IntegrationType_ToString(IntegrationType);
    static bool IntegrationType_FromString(const std::string &, IntegrationType &);
protected:
    static std::string IntegrationType_ToString(int);
public:
    static std::string SizeType_ToString(SizeType);
    static bool SizeType_FromString(const std::string &, SizeType &);
protected:
    static std::string SizeType_ToString(int);
public:
    static std::string ParallelizationAlgorithmType_ToString(ParallelizationAlgorithmType);
    static bool ParallelizationAlgorithmType_FromString(const std::string &, ParallelizationAlgorithmType &);
protected:
    static std::string ParallelizationAlgorithmType_ToString(int);
public:
    static std::string OperationType_ToString(OperationType);
    static bool OperationType_FromString(const std::string &, OperationType &);
protected:
    static std::string OperationType_ToString(int);
public:
    static std::string CauchyGreenTensor_ToString(CauchyGreenTensor);
    static bool CauchyGreenTensor_FromString(const std::string &, CauchyGreenTensor &);
protected:
    static std::string CauchyGreenTensor_ToString(int);
public:
    static std::string EigenComponent_ToString(EigenComponent);
    static bool EigenComponent_FromString(const std::string &, EigenComponent &);
protected:
    static std::string EigenComponent_ToString(int);
public:
    static std::string OperatorType_ToString(OperatorType);
    static bool OperatorType_FromString(const std::string &, OperatorType &);
protected:
    static std::string OperatorType_ToString(int);
public:
    static std::string TerminationType_ToString(TerminationType);
    static bool TerminationType_FromString(const std::string &, TerminationType &);
protected:
    static std::string TerminationType_ToString(int);
public:
    static std::string PathlinesCMFE_ToString(PathlinesCMFE);
    static bool PathlinesCMFE_FromString(const std::string &, PathlinesCMFE &);
protected:
    static std::string PathlinesCMFE_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    bool ChangesRequireRecalculation(const LCSAttributes &) const;

    // IDs that can be used to identify fields in case statements
    enum {
        ID_sourceType = 0,
        ID_Resolution,
        ID_UseDataSetStart,
        ID_StartPosition,
        ID_UseDataSetEnd,
        ID_EndPosition,
        ID_integrationDirection,
        ID_auxiliaryGrid,
        ID_auxiliaryGridSpacing,
        ID_maxSteps,
        ID_operationType,
        ID_cauchyGreenTensor,
        ID_eigenComponent,
        ID_eigenWeight,
        ID_operatorType,
        ID_terminationType,
        ID_terminateBySize,
        ID_termSize,
        ID_terminateByDistance,
        ID_termDistance,
        ID_terminateByTime,
        ID_termTime,
        ID_maxStepLength,
        ID_limitMaximumTimestep,
        ID_maxTimeStep,
        ID_relTol,
        ID_absTolSizeType,
        ID_absTolAbsolute,
        ID_absTolBBox,
        ID_fieldType,
        ID_fieldConstant,
        ID_velocitySource,
        ID_integrationType,
        ID_clampLogValues,
        ID_parallelizationAlgorithmType,
        ID_maxProcessCount,
        ID_maxDomainCacheSize,
        ID_workGroupSize,
        ID_pathlines,
        ID_pathlinesOverrideStartingTimeFlag,
        ID_pathlinesOverrideStartingTime,
        ID_pathlinesPeriod,
        ID_pathlinesCMFE,
        ID_thresholdLimit,
        ID_radialLimit,
        ID_boundaryLimit,
        ID_seedLimit,
        ID_issueAdvectionWarnings,
        ID_issueBoundaryWarnings,
        ID_issueTerminationWarnings,
        ID_issueStepsizeWarnings,
        ID_issueStiffnessWarnings,
        ID_issueCriticalPointsWarnings,
        ID_criticalPointThreshold,
        ID__LAST
    };

private:
    int    sourceType;
    int    Resolution[3];
    int    UseDataSetStart;
    double StartPosition[3];
    int    UseDataSetEnd;
    double EndPosition[3];
    int    integrationDirection;
    int    auxiliaryGrid;
    double auxiliaryGridSpacing;
    int    maxSteps;
    int    operationType;
    int    cauchyGreenTensor;
    int    eigenComponent;
    double eigenWeight;
    int    operatorType;
    int    terminationType;
    bool   terminateBySize;
    double termSize;
    bool   terminateByDistance;
    double termDistance;
    bool   terminateByTime;
    double termTime;
    double maxStepLength;
    bool   limitMaximumTimestep;
    double maxTimeStep;
    double relTol;
    int    absTolSizeType;
    double absTolAbsolute;
    double absTolBBox;
    int    fieldType;
    double fieldConstant;
    double velocitySource[3];
    int    integrationType;
    bool   clampLogValues;
    int    parallelizationAlgorithmType;
    int    maxProcessCount;
    int    maxDomainCacheSize;
    int    workGroupSize;
    bool   pathlines;
    bool   pathlinesOverrideStartingTimeFlag;
    double pathlinesOverrideStartingTime;
    double pathlinesPeriod;
    int    pathlinesCMFE;
    double thresholdLimit;
    double radialLimit;
    double boundaryLimit;
    int    seedLimit;
    bool   issueAdvectionWarnings;
    bool   issueBoundaryWarnings;
    bool   issueTerminationWarnings;
    bool   issueStepsizeWarnings;
    bool   issueStiffnessWarnings;
    bool   issueCriticalPointsWarnings;
    double criticalPointThreshold;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define LCSATTRIBUTES_TMFS "iIiDiDiidiiiidiibdbdbddbddiddidDibiiiibbddidddibbbbbbd"

#endif
