// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtIsovolumeFilter.h
// ************************************************************************* //

#ifndef AVT_Isovolume_FILTER_H
#define AVT_Isovolume_FILTER_H

#include <avtPluginDataTreeIterator.h>

#include <IsovolumeAttributes.h>

class vtkDataSet;


// ****************************************************************************
//  Class: avtIsovolumeFilter
//
//  Purpose:
//      A plugin operator for Isovolume.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri Jan 30 14:50:21 PST 2004
//
//  Modifications:
//    Jeremy Meredith, Mon Feb 16 19:12:11 PST 2004
//    Added UpdateDataObjectInfo.  This was needed for correct support
//    on various mesh types.
//
//    Jeremy Meredith, Thu May  6 11:37:47 PDT 2004
//    Split some code from ExecuteData into a new function to avoid
//    code duplication.
//
//    Hank Childs, Wed Aug 11 09:23:17 PDT 2004
//    Added ModifyContract.
//
//    Eric Brugger, Wed Jul 30 18:47:23 PDT 2014
//    Modified the class to work with avtDataRepresentation.
//
// ****************************************************************************

class avtIsovolumeFilter : public avtPluginDataTreeIterator
{
  public:
                         avtIsovolumeFilter();
    virtual             ~avtIsovolumeFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtIsovolumeFilter"; };
    virtual const char  *GetDescription(void)
                             { return "Isovolume"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

  protected:
    IsovolumeAttributes   atts;

    virtual avtDataRepresentation *ExecuteData(avtDataRepresentation *);
    virtual void          UpdateDataObjectInfo(void);

    virtual avtContract_p
                          ModifyContract(avtContract_p);

  private:
    bool VTKmAble(avtDataRepresentation *in) const;
    virtual vtkDataSet   *ExecuteSingleClip(vtkDataSet *, float, bool);
    virtual avtDataRepresentation   *ExecuteData_VTK(avtDataRepresentation *in, std::vector<double> bounds, std::vector<bool> clips);
    virtual avtDataRepresentation   *ExecuteData_VTKM(avtDataRepresentation *in, std::vector<double> bounds, std::vector<bool> clips);
};


#endif
