// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISISOVOLUMEWINDOW_H
#define QVISISOVOLUMEWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>

class IsovolumeAttributes;
class QLabel;
class QLineEdit;
class QvisVariableButton;

// ****************************************************************************
// Class: QvisIsovolumeWindow
//
// Purpose:
//    Defines QvisIsovolumeWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

class QvisIsovolumeWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisIsovolumeWindow(const int type,
                         IsovolumeAttributes *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisIsovolumeWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
  private slots:
    void lboundProcessText();
    void uboundProcessText();
    void variableChanged(const QString &varName);
  private:
    QLineEdit *lbound;
    QLineEdit *ubound;
    QvisVariableButton *variable;
    QLabel *lboundLabel;
    QLabel *uboundLabel;
    QLabel *variableLabel;

    IsovolumeAttributes *atts;
};



#endif
