// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  IsovolumeScriptingPluginInfo.C
// ************************************************************************* //
#include <PyIsovolumeAttributes.h>
#include <IsovolumePluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(Isovolume,Scripting)

// ****************************************************************************
// Method: IsovolumeScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
IsovolumeScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyIsovolumeAttributes_StartUp((IsovolumeAttributes *)subj, data);
}

// ****************************************************************************
// Method: IsovolumeScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
IsovolumeScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyIsovolumeAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: IsovolumeScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is Isovolume plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
IsovolumeScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyIsovolumeAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: IsovolumeScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
IsovolumeScriptingPluginInfo::GetLogString()
{
    std::string s(PyIsovolumeAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: IsovolumeScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
IsovolumeScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyIsovolumeAttributes_SetDefaults((const IsovolumeAttributes *)atts);
}
