// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: IsovolumePluginInfo.h
// ****************************************************************************

#ifndef ISOVOLUME_PLUGIN_INFO_H
#define ISOVOLUME_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class IsovolumeAttributes;

// ****************************************************************************
//  Class: IsovolumePluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an Isovolume operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class IsovolumeGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class IsovolumeCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual IsovolumeGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class IsovolumeGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual IsovolumeCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
    virtual const char **XPMIconData() const;
};

class IsovolumeViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual IsovolumeCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static IsovolumeAttributes *defaultAtts;
    static IsovolumeAttributes *clientAtts;
};

class IsovolumeViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual IsovolumeViewerEnginePluginInfo
{
  public:
    virtual const char **XPMIconData() const;
};

class IsovolumeEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual IsovolumeViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class IsovolumeScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual IsovolumeCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
