// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: IsovolumeGUIPluginInfo.C
// ****************************************************************************

#include <IsovolumePluginInfo.h>
#include <IsovolumeAttributes.h>
#include <QApplication>
#include <QvisIsovolumeWindow.h>

VISIT_OPERATOR_PLUGIN_ENTRY(Isovolume,GUI)

// ****************************************************************************
//  Method: IsovolumeGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
IsovolumeGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("OperatorNames", "Isovolume"));
}


// ****************************************************************************
//  Method: IsovolumeGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
IsovolumeGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisIsovolumeWindow(type, (IsovolumeAttributes *)attr,
        caption, shortName, notepad);
}

// ****************************************************************************
//  Method: IsovolumeGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

#include <Isovolume.xpm>
const char **
IsovolumeGUIPluginInfo::XPMIconData() const
{
    return Isovolume_xpm;
}

