// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: IsovolumeCommonPluginInfo.C
// ****************************************************************************

#include <IsovolumePluginInfo.h>
#include <IsovolumeAttributes.h>

// ****************************************************************************
//  Method: IsovolumeCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
IsovolumeCommonPluginInfo::AllocAttributes()
{
    return new IsovolumeAttributes;
}

// ****************************************************************************
//  Method: IsovolumeCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Isovolume attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
IsovolumeCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((IsovolumeAttributes *) to) = *((IsovolumeAttributes *) from);
}
