// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtIsosurfaceFilter.h
// ************************************************************************* //

#ifndef AVT_Isosurface_FILTER_H
#define AVT_Isosurface_FILTER_H


#include <avtSingleFilterFacade.h>
#include <avtPluginFilter.h>
#include <IsosurfaceAttributes.h>


class vtkDataSet;
class avtContourFilter;


// ****************************************************************************
//  Class: avtIsosurfaceFilter
//
//  Purpose:
//      A plugin operator for Isosurface.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Apr 16 10:37:31 PDT 2002
//
//  Modifications:
//
//    Tom Fogal, Tue Jun 23 20:49:34 MDT 2009
//    Added const version of GetFacadedFilter.
//
// ****************************************************************************

class avtIsosurfaceFilter : virtual public avtPluginFilter,
                            virtual public avtSingleFilterFacade
{
  public:
                         avtIsosurfaceFilter();
    virtual             ~avtIsosurfaceFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtIsosurfaceFilter"; };
    virtual const char  *GetDescription(void)
                             { return "Calculating isosurface"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

  protected:
    avtContourFilter      *cf;
    IsosurfaceAttributes   atts;

    virtual avtFilter       *GetFacadedFilter();
    virtual const avtFilter *GetFacadedFilter() const;

    static void UpdateDataObjectInfoCB(avtDataObject_p &input,
                                       avtDataObject_p &output, void *);
};


#endif
