// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyIsosurfaceAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>

// ****************************************************************************
// Module: PyIsosurfaceAttributes
//
// Purpose:
//   Attributes for the isosurface operator
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a IsosurfaceAttributes.
//
struct IsosurfaceAttributesObject
{
    PyObject_HEAD
    IsosurfaceAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewIsosurfaceAttributes(int);

std::string
PyIsosurfaceAttributes_ToString(const IsosurfaceAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    snprintf(tmpStr, 1000, "%scontourNLevels = %d\n", prefix, atts->GetContourNLevels());
    str += tmpStr;
    {   const doubleVector &contourValue = atts->GetContourValue();
        snprintf(tmpStr, 1000, "%scontourValue = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < contourValue.size(); ++i)
        {
            snprintf(tmpStr, 1000, "%g", contourValue[i]);
            str += tmpStr;
            if(i < contourValue.size() - 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const doubleVector &contourPercent = atts->GetContourPercent();
        snprintf(tmpStr, 1000, "%scontourPercent = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < contourPercent.size(); ++i)
        {
            snprintf(tmpStr, 1000, "%g", contourPercent[i]);
            str += tmpStr;
            if(i < contourPercent.size() - 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    const char *contourMethod_names = "Level, Value, Percent";
    switch (atts->GetContourMethod())
    {
      case IsosurfaceAttributes::Level:
          snprintf(tmpStr, 1000, "%scontourMethod = %sLevel  # %s\n", prefix, prefix, contourMethod_names);
          str += tmpStr;
          break;
      case IsosurfaceAttributes::Value:
          snprintf(tmpStr, 1000, "%scontourMethod = %sValue  # %s\n", prefix, prefix, contourMethod_names);
          str += tmpStr;
          break;
      case IsosurfaceAttributes::Percent:
          snprintf(tmpStr, 1000, "%scontourMethod = %sPercent  # %s\n", prefix, prefix, contourMethod_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetMinFlag())
        snprintf(tmpStr, 1000, "%sminFlag = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sminFlag = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%smin = %g\n", prefix, atts->GetMin());
    str += tmpStr;
    if(atts->GetMaxFlag())
        snprintf(tmpStr, 1000, "%smaxFlag = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%smaxFlag = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%smax = %g\n", prefix, atts->GetMax());
    str += tmpStr;
    const char *scaling_names = "Linear, Log";
    switch (atts->GetScaling())
    {
      case IsosurfaceAttributes::Linear:
          snprintf(tmpStr, 1000, "%sscaling = %sLinear  # %s\n", prefix, prefix, scaling_names);
          str += tmpStr;
          break;
      case IsosurfaceAttributes::Log:
          snprintf(tmpStr, 1000, "%sscaling = %sLog  # %s\n", prefix, prefix, scaling_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    snprintf(tmpStr, 1000, "%svariable = \"%s\"\n", prefix, atts->GetVariable().c_str());
    str += tmpStr;
    return str;
}

static PyObject *
IsosurfaceAttributes_Notify(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IsosurfaceAttributes_SetContourNLevels(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the contourNLevels in the object.
    obj->data->SetContourNLevels((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IsosurfaceAttributes_GetContourNLevels(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetContourNLevels()));
    return retval;
}

/*static*/ PyObject *
IsosurfaceAttributes_SetContourValue(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;

    doubleVector  &vec = obj->data->GetContourValue();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the contourValue in the object as modified.
    obj->data->SelectContourValue();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IsosurfaceAttributes_GetContourValue(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the contourValue.
    const doubleVector &contourValue = obj->data->GetContourValue();
    PyObject *retval = PyTuple_New(contourValue.size());
    for(size_t i = 0; i < contourValue.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(contourValue[i]));
    return retval;
}

/*static*/ PyObject *
IsosurfaceAttributes_SetContourPercent(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;

    doubleVector  &vec = obj->data->GetContourPercent();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the contourPercent in the object as modified.
    obj->data->SelectContourPercent();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IsosurfaceAttributes_GetContourPercent(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the contourPercent.
    const doubleVector &contourPercent = obj->data->GetContourPercent();
    PyObject *retval = PyTuple_New(contourPercent.size());
    for(size_t i = 0; i < contourPercent.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(contourPercent[i]));
    return retval;
}

/*static*/ PyObject *
IsosurfaceAttributes_SetContourMethod(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the contourMethod in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetContourMethod(IsosurfaceAttributes::Select_by(ival));
    else
    {
        fprintf(stderr, "An invalid contourMethod value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Level, Value, Percent.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IsosurfaceAttributes_GetContourMethod(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetContourMethod()));
    return retval;
}

/*static*/ PyObject *
IsosurfaceAttributes_SetMinFlag(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the minFlag in the object.
    obj->data->SetMinFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IsosurfaceAttributes_GetMinFlag(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMinFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
IsosurfaceAttributes_SetMin(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the min in the object.
    obj->data->SetMin(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IsosurfaceAttributes_GetMin(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMin());
    return retval;
}

/*static*/ PyObject *
IsosurfaceAttributes_SetMaxFlag(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxFlag in the object.
    obj->data->SetMaxFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IsosurfaceAttributes_GetMaxFlag(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMaxFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
IsosurfaceAttributes_SetMax(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the max in the object.
    obj->data->SetMax(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IsosurfaceAttributes_GetMax(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMax());
    return retval;
}

/*static*/ PyObject *
IsosurfaceAttributes_SetScaling(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the scaling in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetScaling(IsosurfaceAttributes::Scaling(ival));
    else
    {
        fprintf(stderr, "An invalid scaling value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Linear, Log.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IsosurfaceAttributes_GetScaling(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetScaling()));
    return retval;
}

/*static*/ PyObject *
IsosurfaceAttributes_SetVariable(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the variable in the object.
    obj->data->SetVariable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IsosurfaceAttributes_GetVariable(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetVariable().c_str());
    return retval;
}



PyMethodDef PyIsosurfaceAttributes_methods[ISOSURFACEATTRIBUTES_NMETH] = {
    {"Notify", IsosurfaceAttributes_Notify, METH_VARARGS},
    {"SetContourNLevels", IsosurfaceAttributes_SetContourNLevels, METH_VARARGS},
    {"GetContourNLevels", IsosurfaceAttributes_GetContourNLevels, METH_VARARGS},
    {"SetContourValue", IsosurfaceAttributes_SetContourValue, METH_VARARGS},
    {"GetContourValue", IsosurfaceAttributes_GetContourValue, METH_VARARGS},
    {"SetContourPercent", IsosurfaceAttributes_SetContourPercent, METH_VARARGS},
    {"GetContourPercent", IsosurfaceAttributes_GetContourPercent, METH_VARARGS},
    {"SetContourMethod", IsosurfaceAttributes_SetContourMethod, METH_VARARGS},
    {"GetContourMethod", IsosurfaceAttributes_GetContourMethod, METH_VARARGS},
    {"SetMinFlag", IsosurfaceAttributes_SetMinFlag, METH_VARARGS},
    {"GetMinFlag", IsosurfaceAttributes_GetMinFlag, METH_VARARGS},
    {"SetMin", IsosurfaceAttributes_SetMin, METH_VARARGS},
    {"GetMin", IsosurfaceAttributes_GetMin, METH_VARARGS},
    {"SetMaxFlag", IsosurfaceAttributes_SetMaxFlag, METH_VARARGS},
    {"GetMaxFlag", IsosurfaceAttributes_GetMaxFlag, METH_VARARGS},
    {"SetMax", IsosurfaceAttributes_SetMax, METH_VARARGS},
    {"GetMax", IsosurfaceAttributes_GetMax, METH_VARARGS},
    {"SetScaling", IsosurfaceAttributes_SetScaling, METH_VARARGS},
    {"GetScaling", IsosurfaceAttributes_GetScaling, METH_VARARGS},
    {"SetVariable", IsosurfaceAttributes_SetVariable, METH_VARARGS},
    {"GetVariable", IsosurfaceAttributes_GetVariable, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
IsosurfaceAttributes_dealloc(PyObject *v)
{
   IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
IsosurfaceAttributes_compare(PyObject *v, PyObject *w)
{
    IsosurfaceAttributes *a = ((IsosurfaceAttributesObject *)v)->data;
    IsosurfaceAttributes *b = ((IsosurfaceAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyIsosurfaceAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "contourNLevels") == 0)
        return IsosurfaceAttributes_GetContourNLevels(self, NULL);
    if(strcmp(name, "contourValue") == 0)
        return IsosurfaceAttributes_GetContourValue(self, NULL);
    if(strcmp(name, "contourPercent") == 0)
        return IsosurfaceAttributes_GetContourPercent(self, NULL);
    if(strcmp(name, "contourMethod") == 0)
        return IsosurfaceAttributes_GetContourMethod(self, NULL);
    if(strcmp(name, "Level") == 0)
        return PyInt_FromLong(long(IsosurfaceAttributes::Level));
    if(strcmp(name, "Value") == 0)
        return PyInt_FromLong(long(IsosurfaceAttributes::Value));
    if(strcmp(name, "Percent") == 0)
        return PyInt_FromLong(long(IsosurfaceAttributes::Percent));

    if(strcmp(name, "minFlag") == 0)
        return IsosurfaceAttributes_GetMinFlag(self, NULL);
    if(strcmp(name, "min") == 0)
        return IsosurfaceAttributes_GetMin(self, NULL);
    if(strcmp(name, "maxFlag") == 0)
        return IsosurfaceAttributes_GetMaxFlag(self, NULL);
    if(strcmp(name, "max") == 0)
        return IsosurfaceAttributes_GetMax(self, NULL);
    if(strcmp(name, "scaling") == 0)
        return IsosurfaceAttributes_GetScaling(self, NULL);
    if(strcmp(name, "Linear") == 0)
        return PyInt_FromLong(long(IsosurfaceAttributes::Linear));
    if(strcmp(name, "Log") == 0)
        return PyInt_FromLong(long(IsosurfaceAttributes::Log));

    if(strcmp(name, "variable") == 0)
        return IsosurfaceAttributes_GetVariable(self, NULL);

    return Py_FindMethod(PyIsosurfaceAttributes_methods, self, name);
}

int
PyIsosurfaceAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "contourNLevels") == 0)
        obj = IsosurfaceAttributes_SetContourNLevels(self, tuple);
    else if(strcmp(name, "contourValue") == 0)
        obj = IsosurfaceAttributes_SetContourValue(self, tuple);
    else if(strcmp(name, "contourPercent") == 0)
        obj = IsosurfaceAttributes_SetContourPercent(self, tuple);
    else if(strcmp(name, "contourMethod") == 0)
        obj = IsosurfaceAttributes_SetContourMethod(self, tuple);
    else if(strcmp(name, "minFlag") == 0)
        obj = IsosurfaceAttributes_SetMinFlag(self, tuple);
    else if(strcmp(name, "min") == 0)
        obj = IsosurfaceAttributes_SetMin(self, tuple);
    else if(strcmp(name, "maxFlag") == 0)
        obj = IsosurfaceAttributes_SetMaxFlag(self, tuple);
    else if(strcmp(name, "max") == 0)
        obj = IsosurfaceAttributes_SetMax(self, tuple);
    else if(strcmp(name, "scaling") == 0)
        obj = IsosurfaceAttributes_SetScaling(self, tuple);
    else if(strcmp(name, "variable") == 0)
        obj = IsosurfaceAttributes_SetVariable(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
IsosurfaceAttributes_print(PyObject *v, FILE *fp, int flags)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)v;
    fprintf(fp, "%s", PyIsosurfaceAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
IsosurfaceAttributes_str(PyObject *v)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)v;
    return PyString_FromString(PyIsosurfaceAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *IsosurfaceAttributes_Purpose = "Attributes for the isosurface operator";
#else
static char *IsosurfaceAttributes_Purpose = "Attributes for the isosurface operator";
#endif

//
// The type description structure
//
static PyTypeObject IsosurfaceAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "IsosurfaceAttributes",                    // tp_name
    sizeof(IsosurfaceAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)IsosurfaceAttributes_dealloc,  // tp_dealloc
    (printfunc)IsosurfaceAttributes_print,     // tp_print
    (getattrfunc)PyIsosurfaceAttributes_getattr, // tp_getattr
    (setattrfunc)PyIsosurfaceAttributes_setattr, // tp_setattr
    (cmpfunc)IsosurfaceAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)IsosurfaceAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    IsosurfaceAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static IsosurfaceAttributes *defaultAtts = 0;
static IsosurfaceAttributes *currentAtts = 0;

static PyObject *
NewIsosurfaceAttributes(int useCurrent)
{
    IsosurfaceAttributesObject *newObject;
    newObject = PyObject_NEW(IsosurfaceAttributesObject, &IsosurfaceAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new IsosurfaceAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new IsosurfaceAttributes(*defaultAtts);
    else
        newObject->data = new IsosurfaceAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapIsosurfaceAttributes(const IsosurfaceAttributes *attr)
{
    IsosurfaceAttributesObject *newObject;
    newObject = PyObject_NEW(IsosurfaceAttributesObject, &IsosurfaceAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (IsosurfaceAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
IsosurfaceAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewIsosurfaceAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef IsosurfaceAttributesMethods[] = {
    {"IsosurfaceAttributes", IsosurfaceAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *IsosurfaceAttributesObserver = 0;

std::string
PyIsosurfaceAttributes_GetLogString()
{
    std::string s("IsosurfaceAtts = IsosurfaceAttributes()\n");
    if(currentAtts != 0)
        s += PyIsosurfaceAttributes_ToString(currentAtts, "IsosurfaceAtts.");
    return s;
}

static void
PyIsosurfaceAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("IsosurfaceAtts = IsosurfaceAttributes()\n");
        s += PyIsosurfaceAttributes_ToString(currentAtts, "IsosurfaceAtts.");
        cb(s);
    }
}

void
PyIsosurfaceAttributes_StartUp(IsosurfaceAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyIsosurfaceAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(IsosurfaceAttributesObserver == 0)
    {
        IsosurfaceAttributesObserver = new ObserverToCallback(subj,
            PyIsosurfaceAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyIsosurfaceAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete IsosurfaceAttributesObserver;
    IsosurfaceAttributesObserver = 0;
}

PyMethodDef *
PyIsosurfaceAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return IsosurfaceAttributesMethods;
}

bool
PyIsosurfaceAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &IsosurfaceAttributesType);
}

IsosurfaceAttributes *
PyIsosurfaceAttributes_FromPyObject(PyObject *obj)
{
    IsosurfaceAttributesObject *obj2 = (IsosurfaceAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyIsosurfaceAttributes_New()
{
    return NewIsosurfaceAttributes(0);
}

PyObject *
PyIsosurfaceAttributes_Wrap(const IsosurfaceAttributes *attr)
{
    return WrapIsosurfaceAttributes(attr);
}

void
PyIsosurfaceAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    IsosurfaceAttributesObject *obj2 = (IsosurfaceAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyIsosurfaceAttributes_SetDefaults(const IsosurfaceAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new IsosurfaceAttributes(*atts);
}

