// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  IsosurfaceScriptingPluginInfo.C
// ************************************************************************* //
#include <PyIsosurfaceAttributes.h>
#include <IsosurfacePluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(Isosurface,Scripting)

// ****************************************************************************
// Method: IsosurfaceScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
IsosurfaceScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyIsosurfaceAttributes_StartUp((IsosurfaceAttributes *)subj, data);
}

// ****************************************************************************
// Method: IsosurfaceScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
IsosurfaceScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyIsosurfaceAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: IsosurfaceScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is Isosurface plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
IsosurfaceScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyIsosurfaceAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: IsosurfaceScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
IsosurfaceScriptingPluginInfo::GetLogString()
{
    std::string s(PyIsosurfaceAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: IsosurfaceScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
IsosurfaceScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyIsosurfaceAttributes_SetDefaults((const IsosurfaceAttributes *)atts);
}
