// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: IsosurfaceGUIPluginInfo.C
// ****************************************************************************

#include <IsosurfacePluginInfo.h>
#include <IsosurfaceAttributes.h>
#include <QApplication>
#include <QvisIsosurfaceWindow.h>

VISIT_OPERATOR_PLUGIN_ENTRY(Isosurface,GUI)

// ****************************************************************************
//  Method: IsosurfaceGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
IsosurfaceGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("OperatorNames", "Isosurface"));
}


// ****************************************************************************
//  Method: IsosurfaceGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
IsosurfaceGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisIsosurfaceWindow(type, (IsosurfaceAttributes *)attr,
        caption, shortName, notepad);
}

// ****************************************************************************
//  Method: IsosurfaceGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

#include <Isosurface.xpm>
const char **
IsosurfaceGUIPluginInfo::XPMIconData() const
{
    return Isosurface_xpm;
}

