// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: IsosurfaceCommonPluginInfo.C
// ****************************************************************************

#include <IsosurfacePluginInfo.h>
#include <IsosurfaceAttributes.h>

// ****************************************************************************
//  Method: IsosurfaceCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
IsosurfaceCommonPluginInfo::AllocAttributes()
{
    return new IsosurfaceAttributes;
}

// ****************************************************************************
//  Method: IsosurfaceCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Isosurface attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
IsosurfaceCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((IsosurfaceAttributes *) to) = *((IsosurfaceAttributes *) from);
}
